<?php
/**
 * @link http://www.yiiframework.com/
 * @copyright Copyright (c) 2008 Yii Software LLC
 * @license http://www.yiiframework.com/license/
 */

namespace yii\httpclient;

use yii\base\Object;
use yii\helpers\Json;

/**
 * JsonFormatter formats HTTP message as JSON.
 *
 * @author Paul Klimov <klimov.paul@gmail.com>
 * @since 2.0
 */
class JsonFormatter extends Object implements FormatterInterface
{
    /**
     * @var int the encoding options.For more details please refer to
     * <http://www.php.net/manual/en/function.json-encode.php>.
     */
    public $encodeOptions = 0;


    /**
     * @inheritdoc
     */
    public function format(Request $request)
    {
        $request->getHeaders()->set('Content-Type', 'application/json; charset=UTF-8');
        $request->setContent(Json::encode($request->getData(), $this->encodeOptions));
        return $request;
    }
}