<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model backend\modules\ubux\models\Uang */

$this->title = $model->nip;
$this->params['breadcrumbs'][] = ['label' => 'Uangs', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="uang-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->nip], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->nip], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?php $this->widget('zii.widgets.grid.CGridView', array(
    'id'=>'gaji-grid',
    'dataProvider'=>$model->search(),
    'filter'=>$model,
    'columns'=>array(
        'nip',
        'nama',
        array(
        'name'=>'nip',
        'type'=>'raw',
        'header'=>'Gaji Pokok',
        'value'=>'CHtml::encode(number_format($data->gaji_pokok,2))',
        'htmlOptions'=>array('width'=>'','style'=>'text-align:right'),
        ),
        array(
            'name'=>'nip',
            'type'=>'raw',
            'header'=>'Tunjangan',
            'value'=>'CHtml::encode(number_format($data->tunjangan,2))',
            'htmlOptions'=>array('width'=>'','style'=>'text-align:right'),
        ),
        array(
            'name'=>'nip',
            'type'=>'raw',
            'header'=>'Jumlah Gaji',
            'value'=>'CHtml::encode(number_format($data->totalGaji(),2))',
            'htmlOptions'=>array('width'=>'','style'=>'text-align:right'),
        ),
        array(
            'name'=>'nip',
            'type'=>'raw',
            'header'=>'Pajak',
            'value'=>'CHtml::encode(number_format($data->pajak(),2))',
            'htmlOptions'=>array('width'=>'','style'=>'text-align:right'),
        ),
        
        array(
            'name'=>'nip',
            'type'=>'raw',
            'header'=>'gaji Bersih',
            'value'=>'CHtml::encode(number_format($data->gajiBersih(),2))',
            'htmlOptions'=>array('width'=>'','style'=>'text-align:right'),
        ),
        array(
            'class'=>'CButtonColumn',
        ),
    ),
)); ?>

</div>
