<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use yii\grid\GridView;
use yii\data\ArrayDataProvider;
use yii\helpers\Url;
use common\components\ToolsColumn;
use backend\modules\ubux\models\Gaji;

/* @var $this yii\web\View */
/* @var $model backend\modules\ubux\models\Laporan */

//$this->title = $model->laporan_id;
$this->params['breadcrumbs'][] = ['label' => 'Laporans', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="laporan-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <!-- <?= Html::a('Update', ['update', 'id' => $model->laporan_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->laporan_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?> -->
        <?= Html::a('Import', ['gaji/import', 'id' => $model->laporan_id], ['class' => 'btn btn-info']) ?>
    </p>

    <?php
        $count = 0;
        $data = array();
        foreach ($gajiModel as $obj) {
            $data[$obj->nip] = $obj;
        }

        foreach ($data as $key) {
            $count++;
        }

        $dataProvider = new ArrayDataProvider([
            'allModels' => $data,
        ]);

        // echo GridView::widget([
        //     'dataProvider' => $dataProvider,
        //     'columns' => [                
        //         'nama',
        //         'nip',
                                 
        //     ]
        // ]);
        echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'nama',                        
            'laporan.totalGaji.total_gaji',
            // [
            //     'attribute' => 'laporan.totalGaji.total_id',
            //     'value' => 'laporan.totalGaji.total_id',

            // ],

            ['class' => 'common\components\ToolsColumn',
                'template' => '{view} {update} {total} {print} ',// {edit} {cancel}',
                'header' => 'Aksi',
                'buttons' => [
                    'view' => function ($url, $model){
                        return ToolsColumn::renderCustomButton($url, $model, 'View Detail', 'fa fa-eye');
                    },
                    'total' => function ($url, $model){
                        return ToolsColumn::renderCustomButton($url, $model, 'Total', 'fa fa-eye');
                    },
                    'delete' => function ($url, $model){                            
                            return "<li>".Html::a('<span class="fa fa-trash"></span> Hapus', $url, [
                                'title' => Yii::t('yii', 'Legitimate'),
                                'data-confirm' => Yii::t('yii', 'Are you sure to legitimate the program ?'),
                                'data-method' => 'post',
                                 'data-pjax' => '0',
                            ])."</li>";                        
                    },

                    
                    // 'update' => function ($url, $model){
                    //     return ToolsColumn::renderCustomButton($url, $model, 'Update', 'fa fa-gear');

                        // if($model->status_oleh_hrd == "Accepted" || $model->status_oleh_hrd == "Rejected")
                        //     return "";
                        // //return ToolsColumn::renderCustomButton($url, $model, 'Accepts', 'fa fa-check');
                        // else
                        //     return ToolsColumn::renderCustomButton($url, $model, 'Accept', 'fa fa-check');
                    // },
                    // 'delete' => function ($url, $model){
                    //     return ToolsColumn::renderCustomButton($url, $model, 'Delete', 'fa fa-trash');
                        // if($model->status_oleh_hrd == "Rejected" || $model->status_oleh_hrd == "Accepted")
                        //     return "";
                        // else
                        //     return ToolsColumn::renderCustomButton($url, $model, 'Reject', 'fa fa-close');
                    //},
                    'print' => function ($url, $model){
                        return ToolsColumn::renderCustomButton($url, $model, 'Print Gaji', 'fa fa-print');
                    },
                ],
                'urlCreator' => function ($action, $model, $key, $index){
                    if ($action === 'view') {
                        return Url::toRoute(['view-detail', 'id' => $_GET['id'], 'nip' => $key]);
                    }else if ($action === 'total') {
                        return Url::toRoute(['total-gaji/create', 'id' => $_GET['id'], 'nip' => $key]);
                    }else if ($action === 'delete') {
                        return Url::toRoute(['delete', 'id' => $key]);
                    }
                    else if ($action === 'print') {
                        return Url::toRoute(['print', 'id' => $_GET['id']]);
                    }
                }

            ],
        ],         
    ]); 
        echo "<br>" . $count;
    ?>
    
</div>
