<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use yii\grid\GridView;
use yii\data\ArrayDataProvider;
use yii\helpers\Url;
use common\components\ToolsColumn;

/* @var $this yii\web\View */
/* @var $model backend\modules\ubux\models\Laporan */

//$this->title = $model->laporan_id;
$this->params['breadcrumbs'][] = ['label' => 'Laporans', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="laporan-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <?php
        $dataProvider = new ArrayDataProvider([
            'allModels' => $model,            
        ]);

        echo GridView::widget([
            'dataProvider' => $dataProvider,
            'columns' => [                
                'nama',                
                [
                    'attribute' => 'tanggal',
                    'label' => 'Tanggal',
                    'format' => ['date', 'php:d M Y'],
                    'filter' => '',
                ],     
            'jam',
            'laporan.totalGaji.total_gaji',
                ]
            ]);

        
        echo $dataProvider->getTotalCount();
    ?>      
    
    
</div>