<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\helpers\Url;
use common\components\ToolsColumn;

/* @var $this yii\web\View */
/* @var $searchModel backend\modules\ubux\models\search\LaporanSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Laporans';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="laporan-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Laporan', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            // 'laporan_id',
            'bulan_laporan',
            'tahun_laporan',                    
            // 'deleted',
            // 'deleted_at',
            // 'deleted_by',
            // 'created_at',
            // 'created_by',
            // 'updated_at',
            // 'updated_by',
            // 'jam_kerja_id',

            //['class' => 'yii\grid\ActionColumn'],
            ['class' => 'common\components\ToolsColumn',
                'template' => '{view} {update} {delete}',// {edit} {cancel}',
                'header' => 'Aksi',
                'buttons' => [
                    'view' => function ($url, $model){
                        return ToolsColumn::renderCustomButton($url, $model, 'View Detail', 'fa fa-eye');
                    },
                    'update' => function ($url, $model){
                        return ToolsColumn::renderCustomButton($url, $model, 'Update', 'fa fa-gear');

                        // if($model->status_oleh_hrd == "Accepted" || $model->status_oleh_hrd == "Rejected")
                        //     return "";
                        // //return ToolsColumn::renderCustomButton($url, $model, 'Accepts', 'fa fa-check');
                        // else
                        //     return ToolsColumn::renderCustomButton($url, $model, 'Accept', 'fa fa-check');
                    },
                    'delete' => function ($url, $model){                        
                            return "<li>".Html::a('<span class="fa fa-trash"></span> Hapus', $url, [
                                'title' => Yii::t('yii', 'Hapus'),
                                'data-confirm' => Yii::t('yii', 'Apakah anda ingin menghapus ?'),
                                'data-method' => 'post',
                                 'data-pjax' => '0',
                            ])."</li>";                        
                    },
                    // 'print' => function ($url, $model){
                    //     return ToolsColumn::renderCustomButton($url, $model, 'Print Form IB', 'fa fa-print');
                    // }
                ],
                'urlCreator' => function ($action, $model, $key, $index){
                    if ($action === 'view') {
                        return Url::toRoute(['view', 'id' => $key]);
                    }else if ($action === 'update') {
                        return Url::toRoute(['update', 'id' => $key]);
                    }else if ($action === 'delete') {
                        return Url::toRoute(['delete', 'id' => $key]);
                    }
                    // else if ($action === 'print') {
                    //     return Url::toRoute(['print-by-mahasiswa', 'id' => $key]);
                    // }

                }

            ],
        ],         
    ]); ?>

</div>
