<?php

namespace backend\modules\ubux\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\ubux\models\Uang;

/**
 * UangSearch represents the model behind the search form about `backend\modules\ubux\models\Uang`.
 */
class UangSearch extends Uang
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['nip', 'nama'], 'safe'],
            [['gaji_pokok', 'tunjangan'], 'number'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Uang::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'gaji_pokok' => $this->gaji_pokok,
            'tunjangan' => $this->tunjangan,
        ]);

        $query->andFilterWhere(['like', 'nip', $this->nip])
            ->andFilterWhere(['like', 'nama', $this->nama]);

        return $dataProvider;
    }
}
