<?php

namespace backend\modules\ubux\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\modules\ubux\models\Gaji;

/**
 * GajiSearch represents the model behind the search form about `backend\modules\ubux\models\Gaji`.
 */
class GajiSearch extends Gaji
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['gaji_id', 'laporan_id', 'pin', 'nip', 'verifikasi', 'i_o', 'workcode', 'deleted'], 'integer'],
            [['tanggal_scan', 'tanggal', 'jam', 'nama', 'jabatan', 'departemen', 'kantor', 'mesin', 'deleted_at', 'deleted_by', 'created_at', 'created_by', 'updated_at', 'updated_by'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Gaji::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'gaji_id' => $this->gaji_id,
            'laporan_id' => $this->laporan_id,
            'tanggal_scan' => $this->tanggal_scan,
            'tanggal' => $this->tanggal,
            'jam' => $this->jam,
            'pin' => $this->pin,
            'nip' => $this->nip,
            'verifikasi' => $this->verifikasi,
            'i_o' => $this->i_o,
            'workcode' => $this->workcode,
            'deleted' => $this->deleted,
            'deleted_at' => $this->deleted_at,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ]);

        $query->andFilterWhere(['like', 'nama', $this->nama])
            ->andFilterWhere(['like', 'jabatan', $this->jabatan])
            ->andFilterWhere(['like', 'departemen', $this->departemen])
            ->andFilterWhere(['like', 'kantor', $this->kantor])
            ->andFilterWhere(['like', 'mesin', $this->mesin])
            ->andFilterWhere(['like', 'deleted_by', $this->deleted_by])
            ->andFilterWhere(['like', 'created_by', $this->created_by])
            ->andFilterWhere(['like', 'updated_by', $this->updated_by]);

        return $dataProvider;
    }
}
