<?php

namespace backend\modules\ubux\models;

use Yii;

use common\behaviors\TimestampBehavior;
use common\behaviors\BlameableBehavior;
use common\behaviors\DeleteBehavior;

/**
 * This is the model class for table "gaji".
 *
 * @property string $nip
 * @property string $nama
 * @property string $gaji_pokok
 * @property string $tunjangan
 */
class Uang extends \yii\db\ActiveRecord
{

    /**
     * behaviour to add created_at and updatet_at field with current datetime (timestamp)
     * and created_by and updated_by field with current user id (blameable)
     */
    public function behaviors(){
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
            ],
            'delete' => [
                'class' => DeleteBehavior::className(),
            ]
        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'gaji';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['nip'], 'required'],
            [['gaji_pokok', 'tunjangan'], 'number'],
            [['nip'], 'string', 'max' => 5],
            [['nama'], 'string', 'max' => 20]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'nip' => 'Nip',
            'nama' => 'Nama',
            'gaji_pokok' => 'Gaji Pokok',
            'tunjangan' => 'Tunjangan',
        ];
    }

    public function totalGaji()
    {
      $total=$this->gaji_pokok + $this->tunjangan;
      return $total;
    }

    public function pajak()
    {
       $total=$this->gaji_pokok + $this->tunjangan;
       $pajak=$total * 5/100;
       return $pajak;
    }

    public function gajiBersih()
    {
       return $this->totalGaji() - $this->pajak();
    }
}
