<?php

namespace backend\modules\ubux\models;

use Yii;

use common\behaviors\TimestampBehavior;
use common\behaviors\BlameableBehavior;
use common\behaviors\DeleteBehavior;

/**
 * This is the model class for table "ubux_satpam".
 *
 * @property integer $satpam_id
 * @property string $nama
 * @property string $tgl_lahir
 * @property string $alamat
 * @property integer $deleted
 * @property string $deleted_at
 * @property string $deleted_by
 * @property string $created_at
 * @property string $created_by
 * @property string $updated_at
 * @property string $updated_by
 * @property integer $pegawai_id
 *
 * @property UbuxJamKerja[] $ubuxJamKerjas
 * @property HrdxPegawai $pegawai
 */
class Satpam extends \yii\db\ActiveRecord
{

    /**
     * behaviour to add created_at and updatet_at field with current datetime (timestamp)
     * and created_by and updated_by field with current user id (blameable)
     */
    public function behaviors(){
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
            ],
            'delete' => [
                'class' => DeleteBehavior::className(),
            ]
        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'ubux_satpam';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['deleted', 'pegawai_id'], 'integer'],
            [['deleted_at', 'created_at', 'updated_at'], 'safe'],
            [['nama', 'tgl_lahir', 'alamat'], 'string', 'max' => 45],
            [['deleted_by', 'created_by', 'updated_by'], 'string', 'max' => 32],
            [['pegawai_id'], 'exist', 'skipOnError' => true, 'targetClass' => HrdxPegawai::className(), 'targetAttribute' => ['pegawai_id' => 'pegawai_id']]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'satpam_id' => 'Satpam ID',
            'nama' => 'Nama',
            'tgl_lahir' => 'Tgl Lahir',
            'alamat' => 'Alamat',
            'deleted' => 'Deleted',
            'deleted_at' => 'Deleted At',
            'deleted_by' => 'Deleted By',
            'created_at' => 'Created At',
            'created_by' => 'Created By',
            'updated_at' => 'Updated At',
            'updated_by' => 'Updated By',
            'pegawai_id' => 'Pegawai ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUbuxJamKerjas()
    {
        return $this->hasMany(UbuxJamKerja::className(), ['satpam_id' => 'satpam_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPegawai()
    {
        return $this->hasOne(HrdxPegawai::className(), ['pegawai_id' => 'pegawai_id']);
    }
}
