<?php

namespace backend\modules\ubux\models;

use Yii;

use common\behaviors\TimestampBehavior;
use common\behaviors\BlameableBehavior;
use common\behaviors\DeleteBehavior;

/**
 * This is the model class for table "ubux_laporan".
 *
 * @property integer $laporan_id
 * @property string $bulan_laporan
 * @property integer $deleted
 * @property string $deleted_at
 * @property string $deleted_by
 * @property string $created_at
 * @property string $created_by
 * @property string $updated_at
 * @property string $updated_by
 * @property integer $jam_kerja_id
 *
 * @property UbuxGaji[] $ubuxGajis
 * @property UbuxJamKerja $jamKerja
 */
class Laporan extends \yii\db\ActiveRecord
{

    /**
     * behaviour to add created_at and updatet_at field with current datetime (timestamp)
     * and created_by and updated_by field with current user id (blameable)
     */
    public function behaviors(){
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
            ],
            'delete' => [
                'class' => DeleteBehavior::className(),
            ]
        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'ubux_laporan';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['laporan_id', 'deleted', 'satpam_id'], 'integer'],
            [['laporan_id', 'deleted_at', 'created_at', 'updated_at'], 'safe'],
            [['bulan_laporan', 'tahun_laporan'], 'string', 'max' => 45],
            [['deleted_by', 'created_by', 'updated_by'], 'string', 'max' => 32],
            [['satpam_id'], 'exist', 'skipOnError' => true, 'targetClass' => Satpam::className(), 'targetAttribute' => ['satpam_id' => 'satpam_id']]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'laporan_id' => 'Laporan ID',
            'bulan_laporan' => 'Bulan Laporan',
            'tahun_laporan' => 'Tahun Laporan',
            'deleted' => 'Deleted',
            'deleted_at' => 'Deleted At',
            'deleted_by' => 'Deleted By',
            'created_at' => 'Created At',
            'created_by' => 'Created By',
            'updated_at' => 'Updated At',
            'updated_by' => 'Updated By',
            'satpam_id' => 'Satpam ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGaji(){
        return $this->hasOne(Gaji::className(), ['laporan_id' => 'laporan_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getJamKerja()
    {
        return $this->hasOne(jamKerja::className(), ['jam_kerja_id' => 'jam_kerja_id']);
    }
}
