<?php

namespace backend\modules\ubux\models;

use Yii;

use common\behaviors\TimestampBehavior;
use common\behaviors\BlameableBehavior;
use common\behaviors\DeleteBehavior;

/**
 * This is the model class for table "ubux_jam_kerja".
 *
 * @property integer $jam_kerja_id
 * @property string $total_absen
 * @property integer $satpam_id
 * @property integer $deleted
 * @property string $deleted_at
 * @property string $deleted_by
 * @property string $created_at
 * @property string $updated_at
 * @property string $created_by
 * @property string $updated_by
 *
 * @property UbuxGaji[] $ubuxGajis
 * @property UbuxSatpam $satpam
 */
class JamKerja extends \yii\db\ActiveRecord
{

    /**
     * behaviour to add created_at and updatet_at field with current datetime (timestamp)
     * and created_by and updated_by field with current user id (blameable)
     */
    public function behaviors(){
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
            ],
            'delete' => [
                'class' => DeleteBehavior::className(),
            ]
        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'ubux_jam_kerja';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['total_absen'], 'required'],
            [['satpam_id', 'deleted'], 'integer'],
            [['deleted_at', 'created_at', 'updated_at'], 'safe'],
            [['total_absen'], 'string', 'max' => 45],
            [['deleted_by', 'created_by', 'updated_by'], 'string', 'max' => 32],
            [['satpam_id'], 'exist', 'skipOnError' => true, 'targetClass' => Satpam::className(), 'targetAttribute' => ['satpam_id' => 'satpam_id']]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'jam_kerja_id' => 'Jam Kerja ID',
            'total_absen' => 'Total Absen',
            'satpam_id' => 'Satpam ID',
            'deleted' => 'Deleted',
            'deleted_at' => 'Deleted At',
            'deleted_by' => 'Deleted By',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUbuxGajis()
    {
        return $this->hasMany(Gaji::className(), ['jam_kerja_id' => 'jam_kerja_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSatpam()
    {
        return $this->hasOne(Satpam::className(), ['satpam_id' => 'satpam_id']);
    }
}
