<?php

namespace backend\modules\ubux\models;

use Yii;

use common\behaviors\TimestampBehavior;
use common\behaviors\BlameableBehavior;
use common\behaviors\DeleteBehavior;

/**
 * This is the model class for table "ubux_gaji".
 *
 * @property integer $gaji_id
 * @property string $tanggal_scan
 * @property string $tanggal
 * @property string $jam
 * @property string $pin
 * @property string $nip
 * @property string $nama
 * @property string $jabatan
 * @property string $departemen
 * @property string $kantor
 * @property string $verifikasi
 * @property string $i_o
 * @property string $workcode
 * @property string $mesin
 * @property integer $deleted
 * @property string $deleted_at
 * @property string $created_at
 * @property string $updated_at
 * @property string $deleted_by
 * @property string $created_by
 * @property string $updated_by
 * @property integer $laporan_id
 *
 * @property UbuxLaporan $laporan
 */
class Gaji extends \yii\db\ActiveRecord
{

    /**
     * behaviour to add created_at and updatet_at field with current datetime (timestamp)
     * and created_by and updated_by field with current user id (blameable)
     */
    public function behaviors(){
        return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
            ],
            'blameable' => [
                'class' => BlameableBehavior::className(),
            ],
            'delete' => [
                'class' => DeleteBehavior::className(),
            ]
        ];
    }

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'ubux_gaji';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['tanggal_scan'], 'required'],
            [['tanggal_scan', 'tanggal', 'jam', 'deleted_at', 'created_at', 'updated_at'], 'safe'],
            [['deleted', 'laporan_id'], 'integer'],
            [['pin', 'nip', 'nama', 'jabatan', 'departemen', 'kantor', 'verifikasi', 'i_o', 'workcode', 'mesin'], 'string', 'max' => 45],
            [['deleted_by', 'created_by', 'updated_by'], 'string', 'max' => 32],
            [['laporan_id'], 'exist', 'skipOnError' => true, 'targetClass' => Laporan::className(), 'targetAttribute' => ['laporan_id' => 'laporan_id']]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'gaji_id' => 'Gaji ID',
            'tanggal_scan' => 'Tanggal Scan',
            'tanggal' => 'Tanggal',
            'jam' => 'Jam',
            'pin' => 'Pin',
            'nip' => 'Nip',
            'nama' => 'Nama',
            'jabatan' => 'Jabatan',
            'departemen' => 'Departemen',
            'kantor' => 'Kantor',
            'verifikasi' => 'Verifikasi',
            'i_o' => 'I O',
            'workcode' => 'Workcode',
            'mesin' => 'Mesin',
            'deleted' => 'Deleted',
            'deleted_at' => 'Deleted At',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'deleted_by' => 'Deleted By',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'laporan_id' => 'Laporan ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLaporan()
    {
        return $this->hasOne(Laporan::className(), ['laporan_id' => 'laporan_id']);
    }
}
