<?php

namespace backend\modules\ubux\controllers;

use Yii;
use backend\modules\ubux\models\TotalGaji;
use backend\modules\ubux\models\Laporan;
use backend\modules\ubux\models\Gaji;
use backend\modules\ubux\models\search\TotalGajiSearch;
use yii\data\ArrayDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * TotalGajiController implements the CRUD actions for TotalGaji model.
 */
class TotalGajiController extends Controller
{
    public function behaviors()
    {   
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all TotalGaji models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new TotalGajiSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single TotalGaji model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        // return $this->render('view', [
        //     'model' => $this->findModel($id),
        // ]);
        return $this->redirect(['/ubux/laporan/view', 'id' => $id]);
    }

    /**
     * Creates a new TotalGaji model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id, $nip)
    {   

        $model = new TotalGaji();
        // $modelSearch = $model->find()->where('nip = '.$id)->one();

        $gaji = new Gaji();                    
        $modelCount = $gaji->find()->where('laporan_id = '.$id)->andWhere(['nip' => $nip])->All();
        $count = count($modelCount);
        
        if ($model->load(Yii::$app->request->post())) {
            $model->laporan_id = $id;
            $total_gaji = $count * $model['total_gaji'];
            $gajiku = 'Rp.'.$total_gaji;            
            $model->satpam_id = $nip;
            $model->total_gaji = $gajiku;
            if ($model->validate()) {                
                $model->save();
                // $modelSearch->save();
                return $this->redirect(['view', 'id' => $model->laporan_id]);
            } else {
                $errors = $model->$errors;
                print_r(array_values($errors));
            }            
        } else {
            return $this->render('create', [
                'model' => $model,                 
            ]);
        }
    }

    /**
     * Updates an existing TotalGaji model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->total_id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing TotalGaji model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the TotalGaji model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return TotalGaji the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = TotalGaji::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
