<?php

namespace backend\modules\ubux\controllers;

use Yii;
use backend\modules\ubux\models\Laporan;
use backend\modules\ubux\models\Gaji;
use backend\modules\ubux\models\search\LaporanSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use mPDF;

/**
 * LaporanController implements the CRUD actions for Laporan model.
 */
class LaporanController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Laporan models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new LaporanSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Laporan model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = Gaji::find()->where(['laporan_id' => $id])->All();

        // foreach($model as $data){
        //     echo $data->laporan_id;
        //     echo $data->nama;
        // }
        return $this->render('view', 
            array('model' => $this->findModel($id), 'gajiModel' => $model)
        );
    
    }

    public function actionViewDetail($id, $nip)
    {
        $model = Gaji::find()->where(['laporan_id' => $id])->andWhere(['nip' => $nip])->All();        

        return $this->render('view-detail',[ 
                'model' => $model,   
        ]);
    }

    /**
     * Creates a new Laporan model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Laporan();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->laporan_id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Laporan model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->laporan_id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Laporan model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->softDelete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Laporan model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Laporan the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Laporan::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    public function showAbsen(){
        //$id = "satpam";
        $dataProvider = new ActiveDataProvider([
           'query' => Gaji::find()->where("laporan_id = laporan_id"),
           'pagination' => [
                'pageSize' => 20,
           ],
        ]);

        return $dataProvider;
    }

    public function actionPrint($id)
    {
        $pdf_content = $this->renderPartial('view-pdf',[
                'model' => $this->findModel($id),
            ]);
        $mpdf = new mPDF();
        $mpdf->writeHTML($pdf_content);
        $mpdf->Output();
        exit();
    }
}
