<?php

namespace backend\modules\ubux\controllers;

use Yii;
use backend\modules\ubux\models\Gaji;
use backend\modules\ubux\models\Laporan;
use backend\modules\ubux\models\search\GajiSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * GajiController implements the CRUD actions for Gaji model.
 */
class GajiController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    } 

    /**
     * Lists all Gaji models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new GajiSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Gaji model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Gaji model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Gaji();

        if ($model->load(Yii::$app->request->post())) {            
            if ($model->validate()) {
                $model->save();
                return $this->redirect(['view', 'id' => $model->gaji_id]);
            }else{
                $errors = $model->$errors;
                print_r(array_values($errors));
            }            
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /*public function actionCreate()
    {
        $model = new Gaji();

        if ($model->load(Yii::$app->request->post())) {
            $Pmodel = new Laporan(); 
            $Pmodel->bulan_laporan = $model->bulan_laporan;            
            
            if($Pmodel->save()){
                $model->laporan_id = $Pmodel->laporan_id;          

                if($model->validate()){
                     // echo $model->aktif_star . " " . $model->aktif_end . " " . $Pmodel->tgl_lahir . " " . $Pmodel->alamat;
                    $model->save();
                    return $this->redirect(['view', 'id' => $model->gaji_id]);    
                }else{
                    $errors = $model->errors;
                    print_r(array_values($errors));
                }    
            }else{
                $errors = $Pmodel->errors;
                print_r(array_values($errors));
            }
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }*/

    /**
     * Updates an existing Gaji model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->gaji_id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Gaji model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Gaji model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Gaji the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Gaji::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    public function actionImport($id){
        $searchModel = new GajiSearch();
        $modelImport = new \yii\base\DynamicModel([
                    'fileImport'=>'File Import',
                ]);
        $modelImport->addRule(['fileImport'],'required');
        $modelImport->addRule(['fileImport'],'file',['extensions'=>'ods,xls,xlsx'],['maxSize'=>1024*1024]);

        if(Yii::$app->request->post()){
            $modelImport->fileImport = \yii\web\UploadedFile::getInstance($modelImport,'fileImport');
            if($modelImport->fileImport && $modelImport->validate()){
                $inputFileType = \PHPExcel_IOFactory::identify($modelImport->fileImport->tempName);
                $objReader = \PHPExcel_IOFactory::createReader($inputFileType);
                $objPHPExcel = $objReader->load($modelImport->fileImport->tempName);
                $sheetData = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
                $baseRow = 3;
                while(!empty($sheetData[$baseRow]['A'])){
                    $model = new \backend\modules\ubux\models\Gaji;
                    $model->tanggal_scan = (string)$sheetData[$baseRow]['A'];
                    $model->tanggal = (string)$sheetData[$baseRow]['B'];
                    $model->jam = (string)$sheetData[$baseRow]['C'];
                    $model->pin = (string)$sheetData[$baseRow]['D'];
                    $model->nip = (string)$sheetData[$baseRow]['E'];
                    $model->nama = (string)$sheetData[$baseRow]['F'];
                    $model->jabatan = (string)$sheetData[$baseRow]['G'];
                    $model->departemen = (string)$sheetData[$baseRow]['H'];
                    $model->kantor = (string)$sheetData[$baseRow]['I'];
                    $model->verifikasi = (string)$sheetData[$baseRow]['J'];
                    $model->i_o = (string)$sheetData[$baseRow]['K'];
                    $model->workcode = (string)$sheetData[$baseRow]['L'];
                    $model->mesin = (string)$sheetData[$baseRow]['M'];                    
                    $model->laporan_id = $id;
                    $model->save();
                    $baseRow++;
                }
                Yii::$app->getSession()->setFlash('success','Success');                
                 return $this->redirect(['/ubux/laporan/view', 'id' => $id]);
            }else{
                Yii::$app->getSession()->setFlash('error','Error');
                return $this->redirect(['import']);
            }
        }

        return $this->render('import',[
                'modelImport' => $modelImport,
            ]);
    }

    public function actionPrint($id)
    {
        $pdf_content = $this->renderPartial('view-pdf',[
                'model' => $this->findModel($id),
            ]);
        $mpdf = new mPDF();
        $mpdf->writeHTML($pdf_content);
        $mpdf->Output();
        exit();
    }
}
