package org.perpustakaan.controller;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.perpustakaan.models.Autentifikasi;


@WebServlet("/login.do")
public class LoginController extends HttpServlet {
	private static final long serialVersionUID = 1L;
       
    /**
     * @see HttpServlet#HttpServlet()
     */
    public LoginController() {
        super();
        // TODO Auto-generated constructor stub
    }


	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		String username = request.getParameter("username");
		String password = request.getParameter("password");
		HttpSession session = null;
		RequestDispatcher dispatcher;
		int role = Autentifikasi.isUserEksis(username, password);
		if(role>-1)
		{
			
			session = request.getSession();
			session.setAttribute("username", username);
			if(role == 0)
			{
				//menampilkan view untuk admin
				dispatcher =  request.getRequestDispatcher("viewAdmin.jsp");
				dispatcher.forward(request, response);
				
			}else if(role == 1)
			{
				//menampilkan view untuk anggota
				dispatcher =  request.getRequestDispatcher("viewUser.jsp");
				dispatcher.forward(request, response);
			}
		}else
		{
				//menampilkan view jika login gagal
			dispatcher =  request.getRequestDispatcher("loginFailed.jsp");
			dispatcher.forward(request, response);
		}
		
	}

}
