package org.perpus.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
 
import org.perpus.model.Buku;
import org.perpus.util.DBUtil;	

public class BukuDAOImplementation implements BukuDAO {
 
    private Connection conn;
 
    public BukuDAOImplementation() {
        conn = DBUtil.getConnection();
    }
    @Override
    public void addBuku(Buku buku ) {
        try {
            String query = "insert into buku (isbn, judul, pengarang, penerbit,tahun,harga) values (?,?,?,?,?,?)";
            PreparedStatement preparedStatement = conn.prepareStatement( query );
            preparedStatement.setInt( 1, buku.getIsbn() );
            preparedStatement.setString( 2, buku.getJudul() );
            preparedStatement.setString( 3, buku.getPengarang() );
            preparedStatement.setString( 4, buku.getPenerbit() );
            preparedStatement.setInt( 5, buku.getTahun() );
            preparedStatement.setInt( 6, buku.getHarga() );
            preparedStatement.executeUpdate();
            preparedStatement.close();
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }
    @Override
    public void deleteBuku(int isbn) {
        try {
            String query = "delete from buku where isbn=?";
            PreparedStatement preparedStatement = conn.prepareStatement(query);
            preparedStatement.setInt(1, isbn);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }
    @Override
    public void updateBuku( Buku buku ) {
        try {
            String query = "update buku set judul=?, pengarang=?, penerbit=?, tahun=?, harga=? where isbn=?";
            PreparedStatement preparedStatement = conn.prepareStatement( query );
            preparedStatement.setString( 1, buku.getJudul() );
            preparedStatement.setString( 2, buku.getPengarang() );
            preparedStatement.setString( 3, buku.getPenerbit() );
            preparedStatement.setInt( 4, buku.getTahun() );
            preparedStatement.setInt(5, buku.getHarga());
            preparedStatement.setInt(6, buku.getIsbn());
            preparedStatement.executeUpdate();
            preparedStatement.close();
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }
	@Override
	public List<Buku> getAllBukus() {
		List<Buku> bukus = new ArrayList<Buku>();
        try {
            Statement statement = conn.createStatement();
            ResultSet resultSet = statement.executeQuery( "select * from buku" );
            while( resultSet.next() ) {
                Buku buku = new Buku();
                buku.setIsbn(resultSet.getInt("isbn"));
                buku.setJudul(resultSet.getString("judul"));
                buku.setPengarang(resultSet.getString("pengarang"));
                buku.setPenerbit(resultSet.getString("penerbit"));
                buku.setTahun(resultSet.getInt("tahun"));
                buku.setHarga(resultSet.getInt("harga"));
                bukus.add(buku);                
            }
            resultSet.close();
            statement.close();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return bukus;
	}
	@Override
	public Buku getBukuById(int isbn) {
		Buku buku = new Buku();
        try {
            String query = "select * from buku where isbn=?";
            PreparedStatement preparedStatement = conn.prepareStatement( query );
            preparedStatement.setInt(1, isbn);
            ResultSet resultSet = preparedStatement.executeQuery();
            while( resultSet.next() ) {
            	buku.setIsbn(resultSet.getInt("isbn"));
                buku.setJudul(resultSet.getString("judul"));
                buku.setPengarang(resultSet.getString("pengarang"));
                buku.setPenerbit(resultSet.getString("penerbit"));
                buku.setTahun(resultSet.getInt("tahun"));
                buku.setHarga(resultSet.getInt("harga"));
            }
            resultSet.close();
            preparedStatement.close();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return buku;
    }
    
}