@extends('layout')
@section('judul')
Daftar Biodata
@endsection
@section('konten')
<table class="table table-hover">
	<thead>
		<tr>
			<th>ID</th>
			<th>Image</th>
			<th>FULL NAMES</th>
			<th>SEX</th>
			<th>IDENTITY CARD NM</th>
			<th>BIRTH DATE</th>
			<th>PROVINCE</th>
			<th>DISTRICT</th>
			<th>OPTION</th>
		</tr>
	</thead>
	<div class="row">
		<div class="form-group"> 
			<label>Search </label>
			<input type="text" name="search" id="search" class="form-control">
			<a href="{{ url('biodata/create') }}" class="btn btn-success"><i class="glyphicon glyphicon-plus"></i>Tambah</a>
		</div>
	</div>
	<tbody>
		@foreach($data as $a)
			<tr>
				<td>{{ $a->id }}</td>
				<td>
					<img src="images\{{$a->image}}" style="max-width: 10em; max-height: 10em;"></td>
				<td>{{ $a->fullnames }}</td>
				<td>{{ $a->sex }}</td>
				<td>{{ $a->idcard }}</td>
				<td>{{ $a->birtdate }}</td>
				<td>{{ $a->province }}</td>
				<td>{{ $a->district }}</td>
				<td>
					<a href="{{ url('biodata/'.$a->id.'/edit') }}" class="btn btn-primary"><i class="glyphicon glyphicon-edit"></i></a> 
					<form action="{{ url('biodata/'.$a->id) }}" method="post">
						{{ csrf_field() }}
						<br/>
						<input type="hidden" name="_method" value="DELETE">
						<button type="submit" class="btn btn-danger">
							<i class="glyphicon glyphicon-trash"></i>
						</button>
					</form>
				</td>
			</tr>
		@endforeach
	</tbody>
</table>
@endsection
@section('script')
<script>
	$(document).ready(function(){
		$('#search').on('keyup',function(){
			$value = $(this).val();
			$.ajax({
				type : 'GET',
				url : '{{URL::to('search')}}',
				data : {'search':$value},
				success:function(data){
					$('tbody').html(data);
				}
			});
		});
	});
</script>
@endsection