<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Biodata; //import modelnya

class BiodataController extends Controller
{
    public function index(){
    	$data = Biodata::all(); //select * from 
    	return view('biodata.daftar_biodata')->with('data',$data); 
    }

    public function create(){
    	return view('biodata.buat_biodata');
    }

    public function store(Request $request){
    	Biodata::create($request->all());

    	return redirect('biodata');
    }

    public function edit($id){
        $data = Biodata::find($id);
        return view('biodata.edit_biodata')->with('data',$data);
    }

    public function update(Request $request, $id){
        Biodata::find($id)->update($request->all());

        return redirect('biodata');
    }

    public function destroy($id){
        Biodata::destroy($id); // select * from tugas where id =$id
        return redirect('biodata');
    }

    public function show($id){
        $data = Biodata::find($id);

        return view('biodata.detail_biodata')->with('data',$data);
    }

    public function search(Request $request){
        $output="";
        if($request->ajax()){
            $biodata=Biodata::where('fullnames','LIKE','%'.$request->search.'%')->get();
                                        //->orWhere('lastnames,','LIKE','%'.$request->search.'%');
            if($biodata){
                foreach($biodata as $key => $biodatas){
                    $output.='<tr>'.
                            '<td>'.$biodatas->id.'</td>'.
                            '<td>'.'<img src="images/'.$biodatas->image.'"style="max-width: 10em; max-height: 10em;">'.'</td>'.
                            '<td>'.$biodatas->fullnames.'</td>'.
                            '<td>'.$biodatas->sex.'</td>'.
                            '<td>'.$biodatas->idcard.'</td>'.
                            '<td>'.$biodatas->birtdate.'</td>'.
                            '<td>'.$biodatas->province.'</td>'.
                            '<td>'.$biodatas->district.'</td>'.
                            '<td>'.'<a href="profileMVC/'.$biodatas->id.'/edit" class="btn btn-success" title="edit '.$biodatas->name.'"><i class="glyphicon glyphicon-edit"></i></a>'.
                            '<form action="profileMVC/'.$biodatas->id.'" method="post">'.
                            csrf_field().
                            '<br/><input type="hidden" name="_method" value="delete"><button type="submit" class="btn btn-danger" title="delete '.$biodatas->name.'"><i class="glyphicon glyphicon-trash"></i></button></form>'.
                            '</td>'.
                            '</tr>';
                }
                return Response($output);
            }
        }

    }

}
