@extends('layouts.app')

@section('content')
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-left">
            <h2>Hasil Tani</h2>
        </div>
        <div class="pull-right mb-2">
            @can('product-create')
            <a class="btn btn-success" href="{{ route('hasiltanis.create') }}"> Create New Hasil Tani</a>
            @endcan
        </div>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css" />
        <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.1/bootstrap3-typeahead.min.js"></script>



    </div>
</div>

@if ($message = Session::get('success'))
<div class="alert alert-success">
    <p>{{ $message }}</p>
</div>
@endif

<table class="table table-bordered">
    <tr>
        <th>No</th>
        <th>Nama</th>
        <th>Kategori</th>
        <th>Deskripsi</th>
        <th>Harga</th>
        <th>Tanggal Masuk</th>
        <th>Stok</th>
        <th>Gambar</th>
        <th width="280px">Action</th>
    </tr>
    @foreach ($hasiltanis as $hasiltani)
    <tr>
        <td>{{ ++$i }}</td>
        <td>{{ $hasiltani->nama_hasiltani }}</td>
        <td>{{ $hasiltani->kategori }}</td>
        <td>{{ $hasiltani->deskripsi }}</td>
        <td>{{ $hasiltani->harga }}</td>
        <td>{{ $hasiltani->tgl_masuk }}</td>
        <td>{{ $hasiltani->stok }}</td>
        <td>{{ $hasiltani->gambar }}</td>
        <td>
            <form action="{{ route('hasiltanis.destroy',$hasiltani->id) }}" method="POST">
                <a class="btn btn-info" href="{{ route('hasiltanis.show',$hasiltani->id) }}">Show</a>
                <a class="btn btn-primary" href="{{ route('hasiltanis.edit',$hasiltani->id) }}">Edit</a>
                <button type="submit" class="btn btn-danger">Delete</button>
            </form>
        </td>
    </tr>
    @endforeach
</table>


{!! $hasiltanis->links() !!}

<p class="text-center text-primary"><small>Store Your hasiltani</small></p>
@endsection