@extends('layouts.master')

@section('content')
<label>Search</label>
<form method="get">
	<input type="text" name="search">
	<input type="submit" value="search">
</form>
<a href="{{route('tugas.create')}}" class="btn btn-info pull-right">Create New Client</a>
<table class="table table-striped">
	<tr>
		<th>ID</th>
		<th>IMAGE</th>
		<th>FULL NAME</th>
		<th>SEX</th>
		<th>IDENTITY CARD NR</th>
		<th>BIRTH DATE</th>
		<th>PROVINCE</th>
		<th>DISTRICT</th>
		<th>SECTOR</th>
		<th>CELLAR</th>
		<th>OPTIONS</th>
	</tr>

	@foreach($persons as $person)
		<tr>
			<td>{{$person->id}}</td>
			<<td><img src="image/{{$person->image}}" width="90" height="90"></td>
			<td>{{$person->fullname}}</td>
			<td>{{$person->sex}}</td>
			<td>{{$person->idcardnum}}</td>
			<td>{{$person->birthdate}}</td>
			<td>{{$person->province}}</td>
			<td>{{$person->district}}</td>
			<td>{{$person->sector}}</td>
			<td>{{$person->cellar}}</td>
			<td><a href="{{route('tugas.edit', $person->id)}}" class="btn btn-primary" >Edit</a> | 
				<form class="" action="{{route('tugas.destroy',$person->id)}}" method="POST">
					<input type="hidden" name="_method" value="delete">
					<input type="hidden" name="_token" value="{{csrf_token()}}">
					<input type="submit" class="btn btn-danger" onclick="return confirm('Anda yakin?')" value="Delete">
				</form>
			</td>
		</tr>
	@endforeach
</table>
@endsection 		