<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| This file is where you may define all of the routes that are handled
| by your application. Just tell Laravel the URIs it should respond
| to using a Closure or controller method. Build something great!
|
*/

//Awal
Route::get('/',function(){
    return view('auth.login');
})->middleware('guest');

//Login Pegawai


Route::get('/getImport', 'ExcelController@getImport');
Route::get('/getImportPengunjung', 'ExcelController@getImportPengunjung');
Route::get('/getImportPembayaran', 'ExcelController@getImportPembayaran');

Route::post('/postImport', 'ExcelController@postImport');
Route::post('/postImportPengunjung', 'ExcelController@postImportPengunjung');
Route::post('/postImportPembayaran', 'ExcelController@postImportPembayaran');

Route::get('/getExport', 'ExcelController@getExport');
Route::get('/getExportPengunjung', 'ExcelController@getExportPengunjung');
Route::get('/getExportPembayaran', 'ExcelController@getExportPembayaran');

Route::get('/getPDF', 'PDFController@getPDF');
Route::get('/getPDFPengunjung', 'PDFController@getPDFPengunjung');
Route::get('/getPDFPembayaran', 'PDFController@getPDFPembayaran');

Route::get('/deleteAll', 'ExcelController@deleteAll');
Route::get('/deleteAllPengunjung', 'ExcelController@deleteAllPengunjung');
Route::get('/deleteAllPembayaran', 'ExcelController@deleteAllPembayaran');


// Upload didukung dari Youtube
//Judul Video adalah Laravel 5.3, 5.2 - Download Files From Database (.pdf,.doc,.png,.jpg,.xlsl etc)(360p)
Route::get('upload', 'UploadsController@index');
Route::get('laporanPegawai', 'UploadpController@index');

Route::post('upload/uploadFiles', 'UploadsController@multiple_upload');
Route::post('laporanPegawai/uploadFiles', 'UploadpController@multiple_upload');

Route::get('seeupload', 'UploadseeController@index');
Route::post('seeupload/uploadFiles', 'UploadseeController@multiple_upload');

Route::get('seeuploadPegawai', 'UploadseePegawaiController@index');
Route::post('seeuploadPegawai/uploadFiles', 'UploadseePegawaiController@multiple_upload');

Route::get('profile', 'UserController@profile');

// Routing untuk authentifikasi
Route::group(['namespace' => 'auth'],function(){
	Route::post('/login','LoginController@login')->name('login');
    Route::post('/register','RegisterController@register')->name('register');
    Route::get('/logout',function(){
        Auth::logout();
        return redirect('/');
    })->name('logout');

    //manager
    Route::get('manager/resetpassword','LoginController@resetpass')->name('manager.resetpass')->middleware('manager');
    //pegawai
    Route::get('pegawai/resetpassword','LoginController@resetpass')->name('pegawai.resetpass')->middleware('pegawai');
    //receptionist
    Route::get('receptionist/resetpassword','LoginController@resetpass')->name('receptionist.resetpass')->middleware('receptionist');
    //administrasi
    Route::get('administrasi/resetpassword','LoginController@resetpass')->name('administrasi.resetpass')->middleware('administrasi');
   
    Route::post('resetpassword','LoginController@reset')->name('reset');
});

// Routing untuk user level manager
Route::group(['namespace' => 'backend','prefix' => 'manager','middleware' => 'manager'], function() {
    // Controllers Within The "App\Http\Controllers\manager" Namespace

   
    Route::get('/', function () {
	    return view('backend.dashboard',['title' => 'Dashboard']);
	})->name('manager');
   



    Route::resource('pegawai','PgwCtrl');
    Route::resource('receptionist','RctCtrl');
    Route::resource('administrasi','AdmCtrl');
   
});

// Routing untuk user level pegawai
Route::group(['namespace' => 'pegawai','prefix' => 'pegawai','middleware' => 'pegawai'], function() {
    Route::get('/', function () {
        return view('pegawai.dashboard',['title' => 'Dashboard']);
    })->name('pegawai');

});


Route::group(['namespace' => 'receptionist','prefix' => 'receptionist','middleware' => 'receptionist'], function() {
    Route::get('/', function () {
        return view('receptionist.dashboard',['title' => 'Dashboard']);
    })->name('receptionist');

});

Route::group(['namespace' => 'administrasi','prefix' => 'administrasi','middleware' => 'administrasi'], function() {
    Route::get('/', function () {
        return view('administrasi.dashboard',['title' => 'Dashboard']);
    })->name('administrasi');

});


// CRUD buku didukung dari Youtube
//https://www.youtube.com/watch?v=H_T-2ClHvJY

Route::group(['middleware' => ['web']], function () {
      Route::resource('book', 'BookController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});












Route::group(['middleware' => 'manager'], function () {
      Route::resource('seeupload', 'UploadseeController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});


Route::group(['middleware' => 'receptionist'], function () {
      Route::resource('pengunjung', 'PengunjungController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});

Route::group(['middleware' => 'receptionist'], function () {
      Route::resource('pembayaran', 'PembayaranController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});


Route::group(['middleware' => 'receptionist'], function () {
      Route::resource('kamar', 'KamarController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});

Route::group(['middleware' => 'receptionist'], function () {
      Route::resource('upload', 'UploadsController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});

Route::group(['middleware' => ['pegawai']], function () {
      Route::resource('sbook', 'SBookController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});


Route::group(['middleware' => 'pegawai'], function () {
      Route::resource('laporanPegawai', 'UploadpController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});

// Upload didukung dari Video
//Judul Video adalah Laravel 5.3, 5.2 - Download Files From Database (.pdf,.doc,.png,.jpg,.xlsl etc)(360p)


Route::group(['middleware' => 'administrasi'], function () {
      Route::resource('seeupload', 'UploadseeController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});

Route::group(['middleware' => 'administrasi'], function () {
      Route::resource('seeuploadPegawai', 'UploadseePegawaiController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});


Route::get('/home', 'HomeController@index');

Route::get('pagenotfound', ['as'=> 'notfound', 'uses' => 'HomeController@pagenotfound']);


