<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Pengunjung;

class PengunjungController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       

        $search = \Request::get('search');
        $pengunjungs = Pengunjung::where('nama','like','%'.$search.'%')->orderBy('id')->paginate(3);
        return view('pengunjung.index',['pengunjungs' => $pengunjungs]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       return view('pengunjung.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,['kode_pemesanan'=> 'required','nama'=> 'required', 'jenis_kamar' => 'required', 'kontak' => 'required', 'check_in' => 'required', 'check_out' => 'required',]);

        $pengunjung = new pengunjung;
        $pengunjung->kode_pemesanan = $request->kode_pemesanan;
        $pengunjung->nama = $request->nama;
        $pengunjung->jenis_kamar = $request->jenis_kamar;
        $pengunjung->kontak = $request->kontak;
        $pengunjung->check_in = $request->check_in;
        $pengunjung->check_out = $request->check_out;
        $pengunjung->save();
        return redirect()->route('pengunjung.index')->with('alert-success','Data Hasbeen Saved');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $pengunjung = Pengunjung::findOrFail($id);
    return view('pengunjung.edit', compact('pengunjung'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,['kode_pemesanan'=> 'required','nama'=> 'required', 'jenis_kamar' => 'required', 'kontak' => 'required', 'check_in' => 'required', 'check_out' => 'required',]);

        
        $pengunjung = Pengunjung::findOrFail($id);
        $pengunjung->kode_pemesanan = $request->kode_pemesanan;
        $pengunjung->nama = $request->nama;
        $pengunjung->jenis_kamar = $request->jenis_kamar;
        $pengunjung->kontak = $request->kontak;
        $pengunjung->check_in = $request->check_in;
        $pengunjung->check_out = $request->check_out;
        $pengunjung->save();
        return redirect()->route('pengunjung.index')->with('alert-success','Data Hasbeen Saved');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         $pengunjung = Pengunjung::findOrFail($id);
        $pengunjung->delete();
        return redirect()->route('pengunjung.index')->with('alert-success','Data Hasbeen Deleted');  
    }
}
