<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Kamar;

class kamarController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       

        $kamars = Kamar::all();
        return view('kamar.index',['kamars' => $kamars]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       return view('kamar.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,['jenis_kamar'=> 'required','harga_kamar'=> 'required', 'jumlah_kamar' => 'required',]);

        $kamar = new Kamar;
        $kamar->jenis_kamar = $request->jenis_kamar;
        $kamar->harga_kamar = $request->harga_kamar;
        $kamar->jumlah_kamar = $request->jumlah_kamar;
        $kamar->save();
        return redirect()->route('kamar.index')->with('alert-success','Data Hasbeen Saved');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $kamar = Kamar::findOrFail($id);
    return view('kamar.edit', compact('kamar'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,['jenis_kamar'=> 'required','harga_kamar'=> 'required', 'jumlah_kamar' => 'required',]);

        
        $kamar = kamar::findOrFail($id);
        $kamar->jenis_kamar = $request->jenis_kamar;
        $kamar->harga_kamar = $request->harga_kamar;
        $kamar->jumlah_kamar = $request->jumlah_kamar;
        $kamar->save();
        return redirect()->route('kamar.index')->with('alert-success','Data Hasbeen Saved');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         $kamar = Kamar::findOrFail($id);
        $kamar->delete();
        return redirect()->route('kamar.index')->with('alert-success','Data Hasbeen Deleted');  
    }
}
