<?php

namespace App\Http\Controllers\backend;

use Illuminate\Http\Request;

use App\Http\Requests\reqAdm;
use App\Http\Controllers\Controller;

use App\Models\Administrasi;

use App\Models\Dosen;
use App\User;

class AdmCtrl extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $this->data['title'] = 'Data administrasi';
        $this->data['administrasi'] = Administrasi::orderBy('nip')->paginate(15);
        return view('backend.administrasi.index',$this->data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $this->data['title'] = 'Tambah Data administrasi';
       
        $this->data['jabatan'] = ['Administrasi'];
       
        return view('backend.administrasi.create',$this->data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(reqAdm $request)
    {
        //
        $input = $request->all();
        $input['user_id'] = User::create(['username' => $input['nip'],'password' => bcrypt($input['nip']),'role' => 'administrasi'])->id;
        Administrasi::create($input);
        return redirect()->route('administrasi.index')->with('info','administrasi Berhasil Ditambahkan');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $this->data['title'] = 'Edit Data administrasi';
        $this->data['administrasi'] = Administrasi::find($id);
       
        $this->data['jabatan'] = ['Administrasi'];
       
        return view('backend.administrasi.edit',$this->data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $input = $request->except('_method','_token','mhs_id');
        $mhs = Administrasi::find($id);
        $mhs->update($input);
        $input['user_id'] = User::find($mhs->user_id)->update(['username' => $input['nip'],'password' => bcrypt($input['nip']),'role' => 'administrasi']);
        return redirect()->route('administrasi.index')->with('info','Data administrasi berhasil diubah');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $nilai = Administrasi::find($id);
        $nilai->delete();
        return redirect()->route('administrasi.index')->with('info','Data administrasi berhasil dihapus');
    }
}
