<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Pembayaran;

class PembayaranController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
         $search = \Request::get('search');
        $pembayarans = Pembayaran::where('nama','like','%'.$search.'%')->orderBy('id')->paginate(3);
        return view('pembayaran.index',['pembayarans' => $pembayarans]);
    }
    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    { 
    	return view('pembayaran.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $this->validate($request,['nama'=> 'required','jenis_kamar'=> 'required', 'lama' => 'required',]);

        $pembayaran = new Pembayaran;
        $pembayaran->nama = $request->nama;
        $pembayaran->jenis_kamar = $request->jenis_kamar;
        $pembayaran->lama = $request->lama;
        $pembayaran->save();
        return redirect()->route('pembayaran.create')->with('alert-success','Data Hasbeen Saved');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

     public function edit($id)
    {
        $pembayaran = Pembayaran::findOrFail($id);
    return view('pembayaran.edit', compact('pembayaran'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request,['nama'=> 'required','jenis_kamar'=> 'required', 'lama' => 'required',]);

        
        $pembayaran = pembayaran::findOrFail($id);
        $pembayaran->nama = $request->nama;
        $pembayaran->jenis_kamar = $request->jenis_kamar;
        $pembayaran->lama = $request->lama;
        $pembayaran->save();
        return redirect()->route('pembayaran.index')->with('alert-success','Data Hasbeen Saved');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         $pembayaran = Pembayaran::findOrFail($id);
        $pembayaran->delete();
        return redirect()->route('pembayaran.index')->with('alert-success','Data Hasbeen Deleted');  
    }
   
}

