<?php

namespace App\Http\Controllers;



use App\Http\Request;
use App\Http\Controllers\Controller;
use App\Book;
use App\Pengunjung;
use App\Pembayaran;
use Illuminate\Support\Facades\Input;
use DB;
use Excel;

class ExcelController extends Controller
{
    
//IMPORT

    public function getImport(){
    	return view('excel.importBuku');
    }

     public function getImportPengunjung(){
        return view('excel.importPengunjung');
    }

      public function getImportPembayaran(){
        return view('excel.importPembayaran');
    }



//EXPORT

    public function getExport(){
        $book=Book::all();
        Excel::create('Export Data', function($excel) use($book){
            $excel->sheet('Sheet 1', function($sheet) use($book){
                $sheet->fromArray($book);
            });
        })->export('xlsx');
    }


    public function getExportPengunjung(){
        $pengunjung=Pengunjung::all();
        Excel::create('Export Data Pengunjung', function($excel) use($pengunjung){
            $excel->sheet('Sheet 1', function($sheet) use($pengunjung){
                $sheet->fromArray($pengunjung);
            });
        })->export('xlsx');
    }


    public function getExportPembayaran(){
        $pembayaran=Pembayaran::all();
        Excel::create('Export Data Pembayaran', function($excel) use($pembayaran){
            $excel->sheet('Sheet 1', function($sheet) use($pembayaran){
                $sheet->fromArray($pembayaran);
            });
        })->export('xlsx');
    }




    //POST IMPORT

    public function postImport(){

    	Excel::load(Input::file('book'),function($reader){
    		$reader->each(function($sheet){
    			Book::firstOrCreate($sheet->toArray());
    		});
    	});

        $books = Book::all();
        return view('book.index',['books' => $books]);
    }


    public function postImportPengunjung(){

        Excel::load(Input::file('pengunjung'),function($reader){
            $reader->each(function($sheet){
                Pengunjung::firstOrCreate($sheet->toArray());
            });
        });

        $pengunjungs = Pengunjung::all();
        return view('pengunjung.index',['pengunjungs' => $pengunjungs]);
    }

    public function postImportPembayaran(){

        Excel::load(Input::file('pembayaran'),function($reader){
            $reader->each(function($sheet){
                Pembayaran::firstOrCreate($sheet->toArray());
            });
        });

        $pembayarans = Pembayaran::all();
        return view('pembayaran.index',['pembayarans' => $pembayarans]);
    }



    //DELETE

    public function deleteAll(){
        DB::table('tbl_book')->delete();
        $books = Book::all();
        return view('book.index',['books' => $books]);
    }

    public function deleteAllPengunjung(){
        DB::table('tbl_pengunjung')->delete();
        $pengunjungs = Pengunjung::all();
        return view('pengunjung.index',['pengunjungs' => $pengunjungs]);
    }

     public function deleteAllPembayaran(){
        DB::table('tbl_pembayaran')->delete();
        $pembayarans = Pengunjung::all();
        return view('pembayaran.index',['pembayarans' => $pembayarans]);
    }

    
}
