<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Book;

class BookController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
         $books = Book::all();
        return view('book.index',['books' => $books]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       return view('book.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,['nama_buku'=> 'required','penulis'=> 'required', 'isbn' => 'required',]);

        $book = new book;
        $book->nama_buku = $request->nama_buku;
        $book->penulis = $request->penulis;
        $book->isbn = $request->isbn;
        $book->save();
        return redirect()->route('book.index')->with('alert-success','Data Hasbeen Saved');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $book = Book::findOrFail($id);
    return view('book.edit', compact('book'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,['nama_buku'=> 'required','penulis'=> 'required', 'isbn' => 'required',]);

        $book = Book::findOrFail($id);
        $book->nama_buku = $request->nama_buku;
        $book->penulis = $request->penulis;
        $book->isbn = $request->isbn;
        $book->save();
        return redirect()->route('book.index')->with('alert-success','Data Hasbeen Saved');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         $book = Book::findOrFail($id);
        $book->delete();
        return redirect()->route('book.index')->with('alert-success','Data Hasbeen Deleted');  
    }
}
