package org.perpustakaanku.model;

import java.util.ArrayList;
import java.util.List;

public class DaftarPeminjaman {
	
	private static List<Peminjaman> peminjamans = new ArrayList<>();

	/**
	 * @return the peminjamans
	 */
	public static List<Peminjaman> getPeminjamans() {
		return peminjamans;
	}

	/**
	 * @param peminjamans the peminjamans to set
	 */
	public static void setPeminjamans(List<Peminjaman> peminjamans) {
		DaftarPeminjaman.peminjamans = peminjamans;
	}
	
	/**
	 * 
	 * @param peminjaman the peminjamans to add
	 */
	public static void addToListPeminjamans(String username, String judul){
		Buku buku = DaftarBuku.getBukuFromList(judul);
		if(buku == null || buku.getJumlah()==0){
			return;
		}
		else{
			Peminjaman peminjaman = new Peminjaman(username,judul,"pending");
			DaftarPeminjaman.peminjamans.add(peminjaman);
			buku.setJumlah(buku.getJumlah()-1);
		}
	}
	
	public static Peminjaman getPeminjamanFromList(String username, String judul){
		Buku buku = DaftarBuku.getBukuFromList(judul);
		
		if(buku==null || buku.getJumlah()==0)return null;
		else{
			for(Peminjaman peminjaman : DaftarPeminjaman.peminjamans){
				if(peminjaman.getUsername().compareTo(username)== 0 
						&& peminjaman.getJudul().compareTo(judul)== 0){
					return peminjaman;
				}
			}
			return null;
		}
	}
	
	public static void deletePeminjaman(String username, String judul){
		Peminjaman peminjaman = DaftarPeminjaman.getPeminjamanFromList(username, judul);
		if(peminjaman==null)return;
		else{
			DaftarPeminjaman.peminjamans.remove(peminjaman);
			Buku buku = DaftarBuku.getBukuFromList(judul);
			buku.setJumlah(buku.getJumlah()+1);
		}
	}
	
	public static boolean isPeminjamanExist(String username, String judul){
		for(Peminjaman peminjaman : peminjamans){
			if(peminjaman.getUsername().compareTo(username)==0 && peminjaman.getJudul().compareTo(judul)==0){
				return true;
			}
		}
		return false;
	}
	
	public static void changeStatusPeminjaman(String username,String judul,String status){
		Peminjaman peminjaman = getPeminjamanFromList(username, judul);
		peminjaman.setStatus(status);
	}

}
