package com.example.tad3ti03;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.Toast;

import com.example.tad3ti03.Adapter.AppAdapter;
import com.example.tad3ti03.Model.AppInfo;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class UploadActivity extends AppCompatActivity {

    GridView gridView;
    boolean mIncludeSystemApps;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_upload);

        gridView = findViewById(R.id.griview);
        gridView.setTextFilterEnabled(true);

        gridView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                AppInfo app = (AppInfo) parent.getItemAtPosition(position);
//                Intent myintent = getPackageManager().getLaunchIntentForPackage(app.info.packageName);
                Intent uploadIntent = new Intent(UploadActivity.this, UploadResultActivity.class);
                uploadIntent.putExtra("AppInfo" , app);
                startActivity(uploadIntent);
//                if(myintent == null)
//                {
//                    Toast.makeText(getApplicationContext() , "No launcher attached with this app", Toast.LENGTH_LONG).show();
//                }
//                else
//                {
//                    startActivity(myintent);
//                }
            }
        });

        List<AppInfo> apps = new ArrayList<>();
        PackageManager packageManager = getPackageManager();
        List<ApplicationInfo> infos = packageManager.getInstalledApplications(PackageManager.GET_META_DATA);

        for (ApplicationInfo info:infos)
        {
            if (mIncludeSystemApps && (info.flags & ApplicationInfo.FLAG_SYSTEM) == 1)
            {
                continue;
            }
            AppInfo app = new AppInfo();
            app.info = info;
            app.label = (String) info.loadLabel(packageManager);
            apps.add(app);
        }

        //sort the data

        Collections.sort(apps, new DNComparator());
        gridView.setAdapter(new AppAdapter(UploadActivity.this, apps));

    }

    @Override
    protected void onResume() {
        super.onResume();
    }


    private class DNComparator implements Comparator<AppInfo>
    {

        @Override
        public int compare(AppInfo aa, AppInfo ab) {
            CharSequence sa = aa.label;
            CharSequence sb = ab.label;
            if(sa == null)
            {
                sa = aa.info.packageName;
            }
            if(sb == null)
            {
                sb = ab.info.packageName;
            }
            return Collator.getInstance().compare(sa.toString() , sb.toString());
        }
    }
}

