<?php
function lacero_video( $atts, $content = null ) {

	extract( shortcode_atts(
		array(
			'videolink' => '',
			'title' => '',
			'bg'  => ''
		), $atts )
	);
	
	if( $bg != "" ) {
		$style= 'background-image:url('.wp_get_attachment_url($bg).');';
	}
	else {
		$style = "";
	}
	
	ob_start();

	?>
	<div id="video-section" class="container-fluid video-section no-padding">
		<div class="video-block container-fluid" style="<?php echo esc_attr( $style ); ?>">
			<div class="video-text">
				<a href="<?php echo esc_url($videolink); ?>" class="popup-youtube"><i class="fa fa-play"></i></a>
				<?php echo lacero_content('<p>','</p>',esc_html($title)); ?>
			</div>
		</div>
	</div>
	<?php
	return ob_get_clean();
}
add_shortcode('lacero_video', 'lacero_video');

/* - Video Block */
vc_map( array(
	"name" => esc_html("Video Content", "lacero"),
	"icon" => 'vc-site-icon',
	"base" => "lacero_video",
	"category" => esc_html("lacero", "lacero"),
	"params" => array(
		array(
			"type" => "attach_image",
			"class" => "",
			"heading" => esc_html("Backgroud Image", "lacero"),
			"param_name" => "bg",
		),
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => esc_html("Title", "lacero"),
			"param_name" => "title",
			"holder" => "div",
		),
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => esc_html("Video URL", "lacero"),
			"param_name" => "videolink",
			"holder" => "div",
		),
	)
) );