<?php
function lacero_testimonials_outer( $atts, $content = null ) {

	extract( shortcode_atts( array(

		'title' => '',
		'stitle' => '',
		
		'extra_class' => ''

	), $atts ) );
	
	$result = "
		<div id='testimonial-section' class='testimonial-section container-fluid no-padding $extra_class'>
			<div class='section-padding'></div>
			<div class='container'>
				<div class='section-header'>
					<h3>$title</h3>
					<p>$stitle</p>
				</div>
				<div class='row testimonial'>
					".do_shortcode( $content )."
				</div>
			</div>
			<div class='section-padding'></div>
		</div>";

	return $result;
}
add_shortcode( 'testimonials_outer', 'lacero_testimonials_outer' );

function lacero_testimonials_inner( $atts, $content = null ) {

	extract( shortcode_atts( array(

		'testimonials_image' => '',
		'title' => '',
		'degination' => '',
		'desc' => '',
		'extra_class' => ''
	), $atts ) );

	$testimonials_img = wp_get_attachment_image( $testimonials_image, 'lacero-56-56' );

	$result = "
		<div class='testimonial-box col-md-12 $extra_class'>
			<p>
				<span>“</span>
				$desc
			</p>
			<h3>$testimonials_img $title<span>$degination</span></h3>
		</div>";

	return $result;
}
add_shortcode( 'testimonials_inner', 'lacero_testimonials_inner' );

// Parent Element
function vc_testimonials_outer() {

	// Register "container" content element. It will hold all your inner (child) content elements
	vc_map( array(
		"name" => __("Testimonials", "lacero"),
		"base" => "testimonials_outer",
		"category" => esc_html__("lacero", "lacero"),
		"as_parent" => array('only' => 'testimonials_inner'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
		"content_element" => true,
		"show_settings_on_create" => true,
		"is_container" => true,
		"params" => array(
			// add params same as with any other content element
			array(
				"type" => "textfield",
				"heading" => __("Title", "lacero"),
				"param_name" => "title",
				"holder"=> "div",
			),
			array(
				"type" => "textfield",
				"heading" => __("Sub Title", "lacero"),
				"param_name" => "stitle",
			),
			array(
				"type" => "textfield",
				"heading" => __("Extra class name", "lacero"),
				"param_name" => "el_class",
				"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "lacero")
			)
		),
		"js_view" => 'VcColumnView'
	) );
}
add_action( 'vc_before_init', 'vc_testimonials_outer' );

// Nested Element
function vc_testimonials_inner() {

	vc_map( array(
		"name" => __("Single Testimonials", "lacero"),
		"base" => "testimonials_inner",
		"category" => esc_html__("lacero", "lacero"),
		"content_element" => true,
		"as_child" => array('only' => 'testimonials_outer'), // Use only|except attributes to limit parent (separate multiple values with comma)
		"params" => array(
			// add params same as with any other content element
			array(
				"type" => "attach_image",
				"heading" => __("Testimonials Image", "lacero"),
				"param_name" => "testimonials_image",
			),
			array(
				"type" => "textfield",
				"heading" => __("Title", "lacero"),
				"param_name" => "title",
				"holder" => "div",
			),
			array(
				"type" => "textfield",
				"heading" => __("Degination", "lacero"),
				"param_name" => "degination",
			),
			array(
				"type" => "textarea",
				"heading" => __("Description", "lacero"),
				"param_name" => "desc",
			),
			array(
				"type" => "textfield",
				"heading" => __("Extra class name", "lacero"),
				"param_name" => "el_class",
				"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "lacero")
			)
		)
	) );
}
add_action( 'vc_before_init', 'vc_testimonials_inner' );

// Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {

    class WPBakeryShortCode_Testimonials_Outer extends WPBakeryShortCodesContainer {
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {

    class WPBakeryShortCode_Testimonials_Inner extends WPBakeryShortCode {
    }
}
?>