<?php
function lacero_searchcourch( $atts ) {

	extract( shortcode_atts(
		array(
			'title' => '',
			'stitle' => '',
			'bg' => '',
		), $atts )
	);

	if( $bg != "" ) {
		$style= 'background-image:url('.wp_get_attachment_url($bg).');';
	}
	else {
		$style = "";
	}
	
	ob_start();
		
	$args = array(
		'post_type' => 'lacero_courses',
	);
	$post_tax = 'lacero_course_tax';
	
	?>	
	<div id="search-course-section" class="search-course-section container-fluid no-padding" style="<?php echo esc_attr( $style ); ?>">
		<div class="container">
			<div class="row">
				<div class="section-header">
					<?php echo lacero_content( '<h3>','</h3>', esc_attr($title) ); ?>
					<?php echo lacero_content( '<p>','</p>', esc_attr($stitle) ); ?>
				</div>
				<div class="search-course-inner">
					<form role="search" method="get" id="searchform" class="searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
					<div>
						<label class="screen-reader-text" for="s"><?php _x( 'Search for:', 'label' ); ?></label>
						<input type="text" placeholder="Course Keyword..." value="<?php echo get_search_query(); ?>" name="s" id="s" />
						<input type="submit" id="searchsubmit" value="<?php echo esc_attr_x( 'Search Course', 'submit button' ); ?>" />
					</div>
				</form>
				</div>
			</div>
		</div>
	</div>
	<?php
	return ob_get_clean();
}
add_shortcode('lacero_searchcourch', 'lacero_searchcourch');

/* - Search Courses */
vc_map( array(
	"name" => esc_html("Search Courses", "lacero"),
	"icon" => 'vc-site-icon',
	"base" => "lacero_searchcourch",
	"category" => esc_html("lacero", "lacero"),
	"params" => array(
	
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => esc_html("Title", "lacero"),
			"param_name" => "title",
			"holder" => "div",
		),
		
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => esc_html("Sub Title", "lacero"),
			"param_name" => "stitle",
		),
		
		array(
			"type" => "attach_image",
			"class" => "",
			"heading" => esc_html("Background Image", "lacero"),
			"param_name" => "bg",
		),
	)
) );