<?php
function lacero_courses( $atts ) {

	extract( shortcode_atts(
		array(
			'title' => '',
			'stitle' => '',
			'posts_display' => ''
		), $atts )
	);

	/* Post Arguments */
	$args = array(
		'post_type' => 'lacero_courses',
		'posts_per_page' => $posts_display,
		'order' => 'ASC',
	);
	
	
	if( '' === $posts_display ) :
		$posts_display = 6;		
	endif;
	
	$post_tax = 'lacero_course_tax';
	
	$qry = new WP_Query( $args );
	
	$post = 'lacero_courses';
	
	
	
	ob_start();
	
	?>
	<div  class="container-fluid popular-courses no-padding">
	
		<div class="section-padding"></div>
		
		<div class="container">
		
			<div class="section-header">
				<?php
					echo lacero_content( '<h3>','</h3>',esc_attr($title) );
					echo lacero_content( '<p>','</p>',esc_html($stitle) );
				?>
			</div>
			<?php 
			if( $qry->have_posts() ) {
				?>
				<div class="row">
					<?php
					$cnt = 0;
					while ( $qry->have_posts() ) : $qry->the_post();
						?>
						<div class="col-md-4 col-sm-6">
						
							<div class="courses-box">
							
								<div class="courses-img-box">
								
									<?php the_post_thumbnail( 'lacero-370-360' ); ?>
									
									<div class="courses-box-hover">
									
										<?php the_title('<h3>','</h3>'); ?>
										
										<p><?php echo lacero_excerpt(14); ?></p>
										
										<?php 
										if( get_post_meta( get_the_ID(), 'lacero_cf_courses_duration', true ) != "" || get_post_meta( get_the_ID(), 'lacero_cf_courses_degree', true ) != "" ) { 
											?>
											<p>
												<?php 
													if( get_post_meta( get_the_ID(), 'lacero_cf_courses_duration', true  ) != "" ) { 
														?>
														<span><i class="fa fa-calendar"></i><?php esc_html_e('Course duration : ',"lacero"); ?><?php echo esc_html( get_post_meta( get_the_ID(), 'lacero_cf_courses_duration', true ) ); ?></span>
														<?php
													}
													if( get_post_meta( get_the_ID(), 'lacero_cf_courses_degree', true  ) != "" ) { 
														?>
														<span><i class="fa fa-graduation-cap"></i><?php esc_html_e('Degree Level : ',"lacero"); ?><?php echo esc_html( get_post_meta( get_the_ID(), 'lacero_cf_courses_degree', true ) ); ?></span>
														<?php
													}
												?>
											</p>
											<?php
										}
										?>
										<!-- Button trigger modal -->
										<button type="button" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#myModal-<?php echo esc_attr($cnt); ?>">
										  <?php esc_html_e('Apply Now',"lacero"); ?>
										</button>
										
										<a href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e('Read More',"lacero"); ?></a>
									
									</div>
									
								</div>
								
								<span class="box-toggle"></span>
							</div>
							
							<!-- Modal -->
							<div class="modal fade" id="myModal-<?php echo esc_attr($cnt); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel-<?php echo esc_attr($cnt); ?>">
								<div class="modal-dialog" role="document">
									<div class="modal-content">
										<div class="modal-header">
											<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
											<h4 class="modal-title" id="myModalLabel-<?php echo esc_attr($cnt); ?>"><?php esc_html_e('Registration Form',"lacero"); ?></h4>
										</div>
										 <div class="modal-body">
											<?php echo do_shortcode( lacero_options("registrationform") ); ?>
										</div>
								  
									</div>
								</div>
							</div>
						</div>
						<?php
					$cnt++;
					endwhile;

					// Reset Original Data
					wp_reset_postdata();
					?>		
				</div>
				<?php
			}
			?>
		</div>
		<div class="section-padding"></div>
	</div>
	<?php
	return ob_get_clean();
}
add_shortcode('lacero_courses', 'lacero_courses');

/* - Courses */
vc_map( array(
	"name" => esc_html("Course", "lacero"),
	"icon" => 'vc-site-icon',
	"base" => "lacero_courses",
	"category" => esc_html("lacero", "lacero"),
	"params" => array(
		array(
			"type" => "textfield",
			"heading" => __("Title", "lacero"),
			"param_name" => "title",
			"holder" => "div",
		),
		array(
			"type" => "textfield",
			"heading" => __("Sub Title", "lacero"),
			"param_name" => "stitle",
		),
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => esc_html("Post Per Page Display", "lacero"),
			"param_name" => "posts_display",
			"holder" => "div",
		),
	)
) );