<?php
function lacero_photoslider_outer( $atts, $content = null ) {

	extract( shortcode_atts( array(	
		
		'extra_class' => '',
		
	), $atts ) );
	
	Global $slide_cnt;
	
	$photoslider_image = "";
	
	$slide_cnt = 0;
	
	$str_slide = "";
	
	$str_sliderdata = "";
	
	$result = "";
	
	$cnt_active = "";
	
	for( $cnt=0; $cnt < substr_count($content, 'photoslider_inner'); $cnt++ ) {
		if( $cnt == 0 ) {
			$cnt_active = "class='active'";
		} else {
			$cnt_active = "";
		}
		$str_slide .= "<li data-target='#photo-slider' data-slide-to='$cnt' $cnt_active ></li>";
	}
	
	$result = "	
		<div id='slider-section' class='banner-section container-fluid no-padding $extra_class'>
			<div id='photo-slider' class='carousel slide banner-slider' data-ride='carousel'>	
				<ol class='carousel-indicators'>";
					$result .= "$str_slide";
					
					$result .= "
				</ol>
				<div class='carousel-inner' role='listbox'>
					".do_shortcode( $content )."
				</div>
			</div>
		</div>";
		
		return $result;
}
add_shortcode( 'photoslider_outer', 'lacero_photoslider_outer' );

function lacero_photoslider_inner( $atts, $content = null ) {

	extract( shortcode_atts( array(

		'photoslider_imagethumb' => '',
		'photoslider_image' => '',
		'title' => '',
		'desc' => '',
		'btntxt' => '',
		'btnurl' => '',
		
		'extra_class' => ''

	), $atts ) );
	
	
	$photoslider_imgthumb = wp_get_attachment_image( $photoslider_imagethumb, 'lacero-691-429' );
	
	$photoslider_img = wp_get_attachment_image( $photoslider_image, 'lacero-1920-990' );
	
	Global $slide_cnt;
	
	$slide_cnt++;
	
	$result = "
		<div class='item'>
			<div id='dark-$slide_cnt' class='dark-shape'>
				<svg width='100%' height='100%'>
					<clipPath id='dark_shape-$slide_cnt' clipPathUnits='objectBoundingBox'>
						<polygon points='0.44 0, 1 1, 0 1, 0 0'></polygon>
					</clipPath>
				</svg>
				<div id='triangle-$slide_cnt' class='triangle-shape'>
					<svg width='100%' height='100%'>
						<clipPath id='triangle_shape-$slide_cnt' clipPathUnits='objectBoundingBox'>
							<polygon points='1 0, 1 1, 0 1, 0.53 0'></polygon>
						</clipPath>
					</svg>
					$photoslider_imgthumb
				</div>
			</div>
			$photoslider_img
			<div class='carousel-caption'>
				<div class='container'>
					<div class='col-md-5 col-sm-6 col-xs-6 banner-content'>
						<h3>$title</h3>
						<p>$desc</p>
						<a href='".esc_url( $btnurl )."' class='contact'>$btntxt</a>
					</div>
				</div>
			</div>
		</div>";

	return $result;
}
add_shortcode( 'photoslider_inner', 'lacero_photoslider_inner' );

// Parent Element
function vc_photoslider_outer() {

	// Register "container" content element. It will hold all your inner (child) content elements
	vc_map( array(
		"name" => __("Photo Slider", "lacero"),
		"base" => "photoslider_outer",
		"category" => esc_html__("lacero", "lacero"),
		"as_parent" => array('only' => 'photoslider_inner'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
		"content_element" => true,
		"show_settings_on_create" => true,
		"is_container" => true,
		"params" => array(
			// add params same as with any other content element
			array(
				"type" => "textfield",
				"heading" => __("Extra class name", "lacero"),
				"param_name" => "el_class",
				"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "seowave")
			)
		),
		"js_view" => 'VcColumnView'
	) );
}
add_action( 'vc_before_init', 'vc_photoslider_outer' );

// Nested Element
function vc_photoslider_inner() {

	vc_map( array(
		"name" => __("Single Photo Slider", "lacero"),
		"base" => "photoslider_inner",
		"category" => esc_html__("lacero", "lacero"),
		"content_element" => true,
		"as_child" => array('only' => 'photoslider_outer'), // Use only|except attributes to limit parent (separate multiple values with comma)
		"params" => array(
			// add params same as with any other content element
			array(
				"type" => "attach_image",
				"heading" => __("photoslider Image Thumb", "lacero"),
				"param_name" => "photoslider_imagethumb",
			),
			array(
				"type" => "attach_image",
				"heading" => __("photoslider Full Image", "lacero"),
				"param_name" => "photoslider_image",
			),
			array(
				"type" => "textfield",
				"heading" => __("Title", "lacero"),
				"param_name" => "title",
				"holder" => "div",
			),
			array(
				"type" => "textarea",
				"heading" => __("Description", "lacero"),
				"param_name" => "desc",
			),
			array(
				"type" => "textfield",
				"heading" => __("Button Text", "lacero"),
				"param_name" => "btntxt",
			),
			array(
				"type" => "textfield",
				"heading" => __("Button URL", "lacero"),
				"param_name" => "btnurl",
			),
		)
	) );
}
add_action( 'vc_before_init', 'vc_photoslider_inner' );

// Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {

    class WPBakeryShortCode_Photoslider_Outer extends WPBakeryShortCodesContainer {
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {

    class WPBakeryShortCode_Photoslider_Inner extends WPBakeryShortCode {
    }
}
?>