<?php
function lacero_contact_map( $atts ) {
	
	extract( shortcode_atts(
	
		array(
			'vc_map_lati' => '',
			'vc_map_longi' => '',
			'vc_address' => ''
			
		), $atts )
	);

	ob_start();
	
	?>
	
	<div class="map container-fluid no-padding">
		<div class="map-canvas" id="map-canvas-contact" data-lat="<?php echo esc_html( $vc_map_lati ); ?>" data-lng="<?php echo esc_html( $vc_map_longi ); ?>" data-string="<?php echo esc_html( $vc_address ); ?>" data-marker="<?php echo esc_url( OWTH_LIB ).'images/marker.png'; ?>" data-zoom="12"></div>
	</div>
	
	<?php
	return ob_get_clean();
}
add_shortcode('lacero_contact_map', 'lacero_contact_map');

/* - Contact Map */
vc_map( array(
	"name" => esc_html("Contact Map", "lacero"),
	"icon" => 'vc-site-icon',
	"base" => "lacero_contact_map",
	"category" => esc_html("lacero", "lacero"),
	"params" => array(		
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => esc_html("Map Latitute", "lacero"),
			"param_name" => "vc_map_lati",
			"description" => esc_html("e.g : -35.278930", "lacero"),
		),
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => esc_html("Map Longitute", "lacero"),
			"param_name" => "vc_map_longi",
			"description" => esc_html("e.g : 149.128125", "lacero"),
		),
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => esc_html("Map Marker Address", "lacero"),
			"param_name" => "vc_address",
		),
	)
) );