<?php
function lacero_introduction_outer( $atts, $content = null ) {

	extract( shortcode_atts( array(

		'extra_class' => '',

	), $atts ) );
	
	Global $cnt_count;
	
	$cnt_count= 0;
	
	$result ="
		<div id='intro-section' class='intro-section container-fluid no-padding $extra_class'>
			<div class='section-padding'></div>
			<div class='container'>
				<div class='row'>
					".do_shortcode( $content )."
				</div>
			</div>
			<div class='section-padding'></div>
		</div>";
		
		$cnt_count++;
	
		return $result;
}
add_shortcode( 'introduction_outer', 'lacero_introduction_outer' );

function lacero_introduction_inner( $atts, $content = null ) {

	extract( shortcode_atts( array(

		'intro_image' => '',
		'title' => '',
		'desc' => '',
		
		'extra_class' => ''

	), $atts ) );
	
	Global $cnt_count;
	
	$cnt_count++;
	
	$intro_img = wp_get_attachment_image( $intro_image, 'lacero-33-34' );

	$result = "
		<div class='col-md-3 col-sm-6 col-xs-6 $extra_class'>
			<div class='intro-box bg-color$cnt_count'>	
				<div class='intro-icon'>
					<span>
						<i>
							$intro_img
						</i>
					</span>
				</div>
				<h3>$title</h3>
				<p>$desc</p>
			</div>
		</div>";
		if($cnt_count == 4) {
			$cnt_count = 0;
		}
	return $result;
}
add_shortcode( 'introduction_inner', 'lacero_introduction_inner' );

// Parent Element
function vc_introduction_outer() {

	// Register "container" content element. It will hold all your inner (child) content elements
	vc_map( array(
		"name" => __("Introduction", "lacero"),
		"base" => "introduction_outer",
		"category" => esc_html__("lacero", "lacero"),
		"as_parent" => array('only' => 'introduction_inner'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
		"content_element" => true,
		"show_settings_on_create" => true,
		"is_container" => true,
		"params" => array(
			// add params same as with any other content element
			
			array(
				"type" => "textfield",
				"heading" => __("Extra class name", "lacero"),
				"param_name" => "el_class",
				"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "seowave")
			)
		),
		"js_view" => 'VcColumnView'
	) );
}
add_action( 'vc_before_init', 'vc_introduction_outer' );

// Nested Element
function vc_introduction_inner() {

	vc_map( array(
		"name" => __("Single Introduction", "lacero"),
		"base" => "introduction_inner",
		"category" => esc_html__("lacero", "lacero"),
		"content_element" => true,
		"as_child" => array('only' => 'introduction_outer'), // Use only|except attributes to limit parent (separate multiple values with comma)
		"params" => array(
			// add params same as with any other content element
			
			array(
				"type" => "textfield",
				"heading" => __("Title", "lacero"),
				"param_name" => "title",
				"holder" => "div",
			),
			array(
				"type" => "textarea",
				"heading" => __("Description", "lacero"),
				"param_name" => "desc",
			),
			
			array(
				"type" => "attach_image",
				"heading" => __("Introduction Image", "lacero"),
				"param_name" => "intro_image",
			),
			array(
				"type" => "textfield",
				"heading" => __("Extra class name", "lacero"),
				"param_name" => "el_class",
				"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "seowave")
			)
		)
	) );
}
add_action( 'vc_before_init', 'vc_introduction_inner' );

// Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {

    class WPBakeryShortCode_Introduction_Outer extends WPBakeryShortCodesContainer {
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {

    class WPBakeryShortCode_Introduction_Inner extends WPBakeryShortCode {
    }
}
?>