<?php
function lacero_graduates( $atts, $content = null ) {

	extract( shortcode_atts(
		array(
			'graduates_image' => '',
			'graduates_videoimage' => '',
			'title' => '',
			'desc' => '',
			'degination' => '',
			'videoid' => '',
			'videodesc' => '',
			'layout' => '',
		), $atts )
	);
	
	if( '' === $layout ) :
		$layout = "layout_one";
	endif;
	
	ob_start();

	if( $layout == "layout_one" ) {
		?>
	
		<div id="our-graduate" class="our-graduate-section container-fluid no-padding">
			<div class="container">
				<div class="row">
					<div class="col-md-6 col-sm-6 no-padding content-box">
					<?php echo lacero_content('<h3>','</h3>',esc_attr($title)); ?>
					<?php echo wpautop($desc); ?>
						<span><b><?php esc_html_e('“',"lacero"); ?></b><?php echo esc_attr($degination); ?></span>
					</div>
					<div class="col-md-6 col-sm-6 no-padding video-block">
						<?php echo wp_get_attachment_image( $graduates_videoimage, 'lacero-585-290' ); ?>
						<a href="<?php echo esc_url($videoid); ?>" class="popup-youtube" title=""><i class="fa fa-play"></i></a>
					</div>
				</div>
			</div>
			<div class="graduate-bg container-fluid no-padding">
				<div class="container">
					<div class="row">
						<div class="col-md-6 col-sm-6 no-padding">
							 <?php echo wp_get_attachment_image( $graduates_image, 'lacero-585-400' ); ?>
						</div>
						<div class="col-md-6 col-sm-6 content-box">
							<?php echo lacero_content('<p>','</p>',esc_html($videodesc)); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	
		<?php
	}
	elseif( $layout == "layout_two" ) {
		?>
		<div id="our-graduate" class="our-graduate-section container-fluid no-padding">
			<div class="graduate-bg container-fluid no-padding">
				<div class="container">
					<div class="row">
						<div class="col-md-6 col-sm-6 no-padding">
							<?php echo wp_get_attachment_image( $graduates_image, 'lacero-585-400' ); ?>
						</div>
						<div class="col-md-6 col-sm-6 content-box">
							<?php echo lacero_content('<p>','</p>',esc_html($videodesc)); ?>
						</div>
					</div>
				</div>
			</div>
			<div class="container">
				<div class="row">
					<div class="col-md-6 col-sm-6 no-padding content-box">
						<?php echo lacero_content('<h3>','</h3>',esc_attr($title)); ?>
					<?php echo wpautop($desc); ?>
						<span><b><?php esc_html_e('“',"lacero"); ?></b><?php echo esc_attr($degination); ?></span>
					</div>
					<div class="col-md-6 col-sm-6 no-padding video-block">
						<?php echo wp_get_attachment_image( $graduates_videoimage, 'lacero-585-290' ); ?>
						<a href="<?php echo esc_url($videoid); ?>" class="popup-youtube" title=""><i class="fa fa-play"></i></a>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
	return ob_get_clean();
}
add_shortcode('lacero_graduates', 'lacero_graduates');

/* - Graduates */
vc_map( array(
	"name" => esc_html("Graduates Say", "lacero"),
	"icon" => 'vc-site-icon',
	"base" => "lacero_graduates",
	"category" => esc_html("lacero", "lacero"),
	"params" => array(
		array(
			'type' => 'dropdown',
			'class' => '',
			'heading' => esc_html( 'Layout', "lacero" ),
			'param_name' => 'layout',
			'value' =>array(
				'Layout 1' => 'layout_one',
				'Layout 2' => 'layout_two',
			),
			'description' => esc_html( 'Select Post Layout. Default Layout 1 Select', "lacero" ),
		),
		array(
			"type" => "attach_image",
			"class" => "",
			"heading" => esc_html("Video Background Image", "lacero"),
			"param_name" => "graduates_videoimage",
		),
		array(
			"type" => "attach_image",
			"class" => "",
			"heading" => esc_html("Graduates Image", "lacero"),
			"param_name" => "graduates_image",
		),
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => esc_html("Title", "lacero"),
			"param_name" => "title",
			"holder" => "div",
		),
		array(
			"type" => "textarea",
			"class" => "",
			"heading" => esc_html("Description", "lacero"),
			"param_name" => "desc",
		),
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => esc_html("By", "lacero"),
			"param_name" => "degination",
		),
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => esc_html("Video URL", "lacero"),
			"param_name" => "videoid",
		),
		array(
			"type" => "textarea",
			"class" => "",
			"heading" => esc_html("Video Releted Content", "lacero"),
			"param_name" => "videodesc",
		),
	)
) );