<?php
function lacero_department( $atts ) {

	extract( shortcode_atts(
		array(
			'title' => '',
			'stitle' => '',
		), $atts )
	);

	ob_start();

	$post_type = 'lacero_courses';
	$tax = 'lacero_course_tax';
	$tax_terms = get_terms($tax);
	
	?>
	<div class="container-fluid popular-courses no-padding">
		<div class="section-padding"></div>
		<div class="container">
			<div class="section-header">
				<?php
					echo lacero_content( '<h3>','</h3>',esc_attr($title) );
					echo lacero_content( '<p>','</p>',esc_html($stitle) );
				?>
			</div>
			<?php
			if ($tax_terms) {
				foreach ($tax_terms  as $tax_term) {
					$args=array(
					  'post_type' => $post_type,
					  "$tax" => $tax_term->slug,
					  'post_status' => 'publish',
					  'posts_per_page' => -1,
					  'caller_get_posts'=> 1
					);
				}
				
			?>
			<div class="row">
				<?php
					foreach( $tax_terms as $tax_term ) {
						$args = array(
						'post_type' => $post_type,
						'tax_query' => array(
							array(
							'taxonomy' => $tax,
							'terms' => $tax_term->term_id
							 )
						  ),
						'posts_per_page' => 1
						);
					
					$cpt_qry = new WP_Query( $args );

						if( $cpt_qry->have_posts() ) {

							while ( $cpt_qry->have_posts() ) : $cpt_qry->the_post();
							?>
								<div class="col-md-4 col-sm-6">
									<div class="courses-box">
										<div class="courses-img-box">
											<?php the_post_thumbnail( 'lacero-370-360' ); ?>
											<div class="courses-box-hover">
												<h3><?php echo esc_attr($tax_term->name); ?></h3>
												<p><?php echo lacero_length(esc_html( $tax_term->description ),10 ); ?></p>
												<a href="<?php echo esc_url( get_term_link( $tax_term ) ); ?>"><?php esc_html_e('View Course',"lacero"); ?></a>
											</div>
										</div>
										<span class="box-toggle"></span>
									</div>
								</div>
							<?php
							endwhile;
						}
					}
				// Reset Original Data
				wp_reset_postdata();
				?>		
			</div>
			<?php
			
		}
		?>
		</div>
		<div class="section-padding"></div>
	</div>
	<?php
	return ob_get_clean();
}
add_shortcode('lacero_department', 'lacero_department');

/* - Courses */
vc_map( array(
	"name" => esc_html("Department", "lacero"),
	"icon" => 'vc-site-icon',
	"base" => "lacero_department",
	"category" => esc_html("lacero", "lacero"),
	"params" => array(
		array(
			"type" => "textfield",
			"heading" => __("Title", "lacero"),
			"param_name" => "title",
			"holder" => "div",
		),
		array(
			"type" => "textfield",
			"heading" => __("Sub Title", "lacero"),
			"param_name" => "stitle",
		),
	)
) );