<?php
function lacero_contact_form( $atts, $content = null ) {

	extract( shortcode_atts(
		array(
			'title' => '',
			'stitle' => '',
		), $atts )
	);

	ob_start();
	?>
	<div class="contact-form container-fluid no-padding">
		<div class="container">
			<div class="section-header">
				<?php 
					echo lacero_content('<h3>','</h3>',esc_attr($title)); 
					echo lacero_content('<p>','</p>',esc_html($stitle));
				?>
			</div>
			<div class="contact-form-inner">
				<?php echo do_shortcode( $content ); ?>
			</div>
		</div>
		<div class="section-padding"></div>
	</div>
	<?php
	return ob_get_clean();
}
add_shortcode('lacero_contact_form', 'lacero_contact_form');

/* - Contact Form */
vc_map( array(
	"name" => esc_html("Contact Form", "lacero"),
	"icon" => 'vc-site-icon',
	"base" => "lacero_contact_form",
	"category" => esc_html("lacero", "lacero"),
	"params" => array(
	
		array(
			"type" => "textfield",
			"heading" => __("Title", "lacero"),
			"param_name" => "title",
			"holder" => "div",
		),
		array(
			"type" => "textfield",
			"heading" => __("Sub Title", "lacero"),
			"param_name" => "stitle",
		),
		array(
			"type" => "textarea_html",
			"class" => "",
			"heading" => esc_html("Contact Form Shortcode", "lacero"),
			"description" => esc_html('Here Add Contact Form 7 Shortcode, e.g : [contact-form-7 id="74" title="Contact Page Form"]', "lacero"),
			"param_name" => "content",
			"holder" => "div",
		),
	)
) );	