<?php
function lacero_contact_address( $atts, $content = null ) {

	extract( shortcode_atts(
		array(
			'address' => '',
			'phone' => '',
			'sphone' => '',
			'email' => '',
			'semail' => '',
			'studentphone' => '',
			'studentphoneone' => '',
		), $atts )
	);

	ob_start();
	?>
	
	<div class="contact-us container-fluid no-padding">
		<div class="section-padding"></div>
		<div class="container">
			<div class="col-md-3 col-sm-6 col-xs-6">
				<div class="contact-content">
					<i>
						<img src="<?php echo esc_url( OWTH_LIB ); ?>images/contact-ic-1.png" alt="contact-ic">
					</i>
					<h3><?php esc_html_e('Our Location',"lacero"); ?></h3>
					<?php echo lacero_content('<p>','</p>',esc_html($address)); ?>
				</div>
			</div>
			<div class="col-md-3 col-sm-6 col-xs-6">
				<div class="contact-content">
					<i>
						<img src="<?php echo esc_url( OWTH_LIB ); ?>images/contact-ic-2.png" alt="contact-ic">
					</i>
					<h3><?php esc_html_e('call Us On',"lacero"); ?></h3>
					<p><?php echo esc_html($phone); ?><span><?php echo esc_html($sphone); ?></span></p>
				</div>
			</div>
			<div class="col-md-3 col-sm-6 col-xs-6">
				<div class="contact-content">
					<i>
						<img src="<?php echo esc_url( OWTH_LIB ); ?>images/contact-ic-3.png" alt="contact-ic">
					</i>
					<h3><?php esc_html_e('Send Message',"lacero"); ?></h3>
					<a href="mailto:<?php echo esc_attr($email); ?>"><?php echo esc_attr($email); ?></a>
					<a href="mailto:<?php echo esc_attr($semail); ?>"><?php echo esc_attr($semail); ?></a>
				</div>
			</div>
			<div class="col-md-3 col-sm-6 col-xs-6">
				<div class="contact-content">
					<i>
						<img src="<?php echo esc_url( OWTH_LIB ); ?>images/contact-ic-4.png" alt="contact-ic">
					</i>
					<h3><?php esc_html_e('Students Help Line',"lacero"); ?></h3>
					<p><?php echo esc_html($studentphone); ?><span><?php echo esc_html($studentphoneone); ?></span></p>
				</div>
			</div>
		</div>
	</div>
	<?php
	return ob_get_clean();
}
add_shortcode('lacero_contact_address', 'lacero_contact_address');

/* - Contact Form */
vc_map( array(
	"name" => esc_html("Contact Address", "lacero"),
	"icon" => 'vc-site-icon',
	"base" => "lacero_contact_address",
	"category" => esc_html("lacero", "lacero"),
	"params" => array(
	
		array(
			"type" => "textfield",
			"heading" => __("Contact Address", "lacero"),
			"param_name" => "address",
			"holder" => "div",
		),
		array(
			"type" => "textfield",
			"heading" => __("Phone Number 1", "lacero"),
			"param_name" => "phone",
		),
		array(
			"type" => "textfield",
			"heading" => __("Phone Number 2", "lacero"),
			"param_name" => "sphone",
		),
		array(
			"type" => "textfield",
			"heading" => __("Email 1", "lacero"),
			"param_name" => "email",
		),
		array(
			"type" => "textfield",
			"heading" => __("Email 2", "lacero"),
			"param_name" => "semail",
		),
		array(
			"type" => "textfield",
			"heading" => __("Students Help Line 1", "lacero"),
			"param_name" => "studentphone",
		),
		array(
			"type" => "textfield",
			"heading" => __("Students Help Line 2", "lacero"),
			"param_name" => "studentphoneone",
		),
	)
) );	