<?php
function lacero_blog( $atts ) {

	extract( shortcode_atts(
		array(
			'title' => '',
			'posts_display' => ''
		), $atts )
	);

	/* Post Arguments */
	$args = array(
		'posts_per_page' => $posts_display,
		'ignore_sticky_posts' => 1
	);
	
	$qry = new WP_Query( $args );
	
	if( '' === $posts_display ) :
		$posts_display = 2;		
	endif;
	
	ob_start();

	if( $qry->have_posts() ) {
		?>
		<div id="blog-section" class="container-fluid blog-section no-padding">
			<div class="section-padding"></div>
			<div class="container">
				<div class="row">
				<?php 
					while ( $qry->have_posts() ) : $qry->the_post();
						?>
						<div class="col-md-6 col-sm-6">
							<article class="type-post">

								<?php
								if( has_post_thumbnail() ) {
									?>
									<div class="entry-cover"> 
										<a href="<?php echo esc_url( get_permalink() ); ?>">
											<?php the_post_thumbnail( 'lacero-570-300' ); ?>
										</a>
										<div class="entry-date">
											<span><?php echo get_the_date( 'd', get_the_ID() ); ?></span>
											<span><?php echo get_the_date( 'M', get_the_ID() ); ?></span>
										</div>
									</div>
									<?php
								} ?>
								<h3 class="entry-title">
									<a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a>
								</h3>
								<div class="entry-content">
									<p><?php echo lacero_excerpt(20); ?></p>
								</div>
								<a class="single-read-more" href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e('Read More',"lacero"); ?></a>
							</article>
						</div>
						<?php
					endwhile;

					// Reset Original Data
					wp_reset_postdata();
				?>		
				</div>
			</div>
			<div class="section-padding"></div>
		</div>
		<?php
	}
	return ob_get_clean();
}
add_shortcode('lacero_blog', 'lacero_blog');

/* - Blog */
vc_map( array(
	"name" => esc_html("Blog Post", "lacero"),
	"icon" => 'vc-site-icon',
	"base" => "lacero_blog",
	"category" => esc_html("lacero", "lacero"),
	"params" => array(
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => esc_html("Post Per Page Display", "lacero"),
			"param_name" => "posts_display",
			"holder" => "div",
		),
	)
) );