<?php
function lacero_admissionprocess_outer( $atts, $content = null ) {

	extract( shortcode_atts( array(

		'title' => '',
		'stitle' => '',
		
		'extra_class' => ''

	), $atts ) );
	
	Global $key;
	
	$key = 0;
	
	$result = "
		<div id='admission-process' class='admission-process container-fluid no-padding $extra_class'>
		<div class='section-padding'></div>
		<div class='container'>
			<div class='section-header'>
				<h3>$title</h3>
				<p>$stitle</p>
			</div>
			<div class='row'>
				".do_shortcode( $content )."
			</div>
		</div>
		<div class='section-padding'></div>
	</div>";

	return $result;
}
add_shortcode( 'admissionprocess_outer', 'lacero_admissionprocess_outer' );

function lacero_admissionprocess_inner( $atts, $content = null ) {

	extract( shortcode_atts( array(

		'process_image' => '',
		'title' => '',
		'desc' => '',
		'extra_class' => ''
	), $atts ) );
	
	$process_img = "";
	
	if( $process_image != "" ) {
	
		$process_img .= "<i>";  
		
		$process_img .= wp_get_attachment_image($process_image, 'lacero-30-27' );
			
		$process_img.= "</i>";
	}
	
	Global $key;
	
	$key++;
	
	$count_value = "";
		
		$count_value .="<i>";
		
		$count_value .= sprintf('%02d', $key);
		
		$count_value .= "</i>";
	
	$result = "
		<div class='col-md-3 col-sm-3 $extra_class'>
			<div class='process-box'>
				
				<span>";
					$result .= "$count_value";
					$result .= "
				</span>
				
				<h3>$title</h3>
				<p>$desc</p>";
				
				$result .= "$process_img";
				$result .= "
				
			</div>
		</div>";

	return $result;
}
add_shortcode( 'admissionprocess_inner', 'lacero_admissionprocess_inner' );

// Parent Element
function vc_admissionprocess_outer() {

	// Register "container" content element. It will hold all your inner (child) content elements
	vc_map( array(
		"name" => __("Admission Process", "lacero"),
		"base" => "admissionprocess_outer",
		"category" => esc_html__("lacero", "lacero"),
		"as_parent" => array('only' => 'admissionprocess_inner'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
		"content_element" => true,
		"show_settings_on_create" => true,
		"is_container" => true,
		"params" => array(
			// add params same as with any other content element
			array(
				"type" => "textfield",
				"heading" => __("Title", "lacero"),
				"param_name" => "title",
				"holder"=> "div",
			),
			array(
				"type" => "textfield",
				"heading" => __("Sub Title", "lacero"),
				"param_name" => "stitle",
			),
			array(
				"type" => "textfield",
				"heading" => __("Extra class name", "lacero"),
				"param_name" => "el_class",
				"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "lacero")
			)
		),
		"js_view" => 'VcColumnView'
	) );
}
add_action( 'vc_before_init', 'vc_admissionprocess_outer' );

// Nested Element
function vc_admissionprocess_inner() {

	vc_map( array(
		"name" => __("Single Admission Process", "lacero"),
		"base" => "admissionprocess_inner",
		"category" => esc_html__("lacero", "lacero"),
		"content_element" => true,
		"as_child" => array('only' => 'admissionprocess_outer'), // Use only|except attributes to limit parent (separate multiple values with comma)
		"params" => array(
			// add params same as with any other content element
			array(
				"type" => "attach_image",
				"heading" => __("Process Icon Image", "lacero"),
				"param_name" => "process_image",
			),
			array(
				"type" => "textfield",
				"heading" => __("Title", "lacero"),
				"param_name" => "title",
				"holder" => "div",
			),
			array(
				"type" => "textarea",
				"heading" => __("Description", "lacero"),
				"param_name" => "desc",
			),
			array(
				"type" => "textfield",
				"heading" => __("Extra class name", "lacero"),
				"param_name" => "el_class",
				"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "lacero")
			)
		)
	) );
}
add_action( 'vc_before_init', 'vc_admissionprocess_inner' );

// Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {

    class WPBakeryShortCode_Admissionprocess_Outer extends WPBakeryShortCodesContainer {
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {

    class WPBakeryShortCode_Admissionprocess_Inner extends WPBakeryShortCode {
    }
}
?>