<?php
/**
 * Upcoming Events widget class Lacero
 *
 * @since 2.8.0
 */
class lacero_Widget_UpcomingEvents extends WP_Widget {

	public function __construct() {

		$widget_ops = array( 'classname' => 'widget-upcoming-event', 'description' => esc_html( "Upcoming Events.", "lacero" ) );

		parent::__construct('widget-event', esc_html('LACERO :: Upcoming Events', "lacero"), $widget_ops);
	}

	public function widget($args, $instance) {

		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		ob_start();

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : esc_html( 'Upcoming Events', "lacero" );

		/** This filter is documented in wp-includes/default-widgets.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 3;

		if ( ! $number ) {
			$number = 3;
		}

		/**
		 * Filter the arguments for the Recent Posts widget.
		 *
		 * @since 3.4.0
		 *
		 * @see WP_Query::get_posts()
		 *
		 * @param array $args An array of arguments used to retrieve the recent posts.
		 */
		$qry_args = array (
			'post_type'              => 'lacero_events',
			'post_status'            => 'publish',
			'posts_per_page'         => $number,
			'order'                  => 'DESC',
			'orderby'                => 'rand',
		);

		$qry = new WP_Query( $qry_args );

		echo html_entity_decode( $args['before_widget'] );

		if ( $title ) {
			echo html_entity_decode( $args['before_title'] . $title . $args['after_title'] );
		}

		while ( $qry->have_posts() ) : $qry->the_post();
			?>
			<div class="recent-event">
				<a  href="<?php echo esc_url( the_permalink() ); ?>"><?php the_post_thumbnail('lacero-79-78'); ?></a>
				<h5><a href="<?php echo esc_url( the_permalink() ); ?>"><?php the_title(); ?></a></h5>
				<span><a href="<?php echo esc_url( the_permalink() ); ?>"><?php echo get_the_date( 'j M Y', get_the_ID() ); ?></a></span>
			</div>
			
			<?php
		endwhile;

		echo html_entity_decode( $args['after_widget'] );

		// Reset the global $the_post as this query will have stomped on it
		wp_reset_postdata();
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = (int) $new_instance['number'];

		return $instance;
	}

	public function form( $instance ) {

		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 2;
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', "lacero" ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of posts to show:', "lacero" ); ?></label>
			<input id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" size="2" />
		</p>
		<?php
	}
}
?>