<?php
/**
 * Recent Tweets Widget class
 *
 * @since 1.0
 */
class lacero_Widget_Recent_Tweets extends WP_Widget {

	public function __construct() {
		$widget_ops = array('classname' => 'widget_latest_tweets', 'description' => esc_html( 'To Show latest twitter tweets.', "lacero" ) );
		parent::__construct( 'recent_tweets', esc_html( 'LACERO :: Recent Tweets', 'Recent Tweets widget' , "lacero" ), $widget_ops );
	}

	public function form( $instance ) {
		$instance = wp_parse_args( (array) $instance,
		array(
			'title' => esc_html('Latest Tweets', "lacero" ),
			'count' => '3',
			'username' => '',
			'exclude_replies' => '1',
			'time' => '1',
			'display_avatar' => '0',
			'consumer_key' => '',
			'consumer_secret' => '',
			'access_token' => '',
			'access_token_secret' => ''
		));

		$title = 					empty($instance['title']) ?	'' : strip_tags($instance['title']);
		$consumer_key = 			empty($instance['consumer_key']) ?	'' : strip_tags($instance['consumer_key']);
		$consumer_secret = 			empty($instance['consumer_secret']) ?	'' : strip_tags($instance['consumer_secret']);
		$access_token = 			empty($instance['access_token']) ?	'' : strip_tags($instance['access_token']);
		$access_token_secret = 		empty($instance['access_token_secret']) ?	'' : strip_tags($instance['access_token_secret']);
		$count = 					empty($instance['count']) ? '' : strip_tags($instance['count']);
		$username = 				empty($instance['username']) ? '' : strip_tags($instance['username']);
		$exclude_replies = 			empty($instance['exclude_replies']) ? 0 : 1;
		$time = 					empty($instance['time']) ? 0 : 1;
		$display_avatar = 			empty($instance['display_avatar']) ? 0 : 1;?>

		<p>
			<label for="<?php echo esc_html( $this->get_field_id('title') ); ?>"><?php esc_html_e('Title:', "lacero" );?> 
			<input class="widefat" id="<?php echo esc_html( $this->get_field_id('title') ); ?>" name="<?php echo esc_html( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></label>
		</p>

		<p>
			<label for="<?php echo esc_html( $this->get_field_id('consumer_key') ); ?>"><?php esc_html_e('Consumer Key:', "lacero" );?> 
			<input class="widefat" id="<?php echo esc_html( $this->get_field_id('consumer_key') ); ?>" name="<?php echo esc_html( $this->get_field_name('consumer_key') ); ?>" type="text" value="<?php echo esc_attr($consumer_key); ?>" /></label>
		</p>

		<p>
			<label for="<?php echo esc_html( $this->get_field_id('consumer_secret') ); ?>"><?php esc_html_e('Consumer Secret:', "lacero" );?> 
			<input class="widefat" id="<?php echo esc_html( $this->get_field_id('consumer_secret') ); ?>" name="<?php echo esc_html( $this->get_field_name('consumer_secret') ); ?>" type="text" value="<?php echo esc_attr($consumer_secret); ?>" /></label>
		</p>

		<p>
			<label for="<?php echo esc_html( $this->get_field_id('access_token') ); ?>"><?php esc_html_e('Access Token:', "lacero" );?> 
			<input class="widefat" id="<?php echo esc_html( $this->get_field_id('access_token') ); ?>" name="<?php echo esc_html( $this->get_field_name('access_token') ); ?>" type="text" value="<?php echo esc_attr($access_token); ?>" /></label>
		</p>

		<p>
			<label for="<?php echo esc_html( $this->get_field_id('access_token_secret') ); ?>"><?php esc_html_e('Access Token Secret:', "lacero" );?> 
			<input class="widefat" id="<?php echo esc_html( $this->get_field_id('access_token_secret') ); ?>" name="<?php echo esc_html( $this->get_field_name('access_token_secret') ); ?>" type="text" value="<?php echo esc_attr($access_token_secret); ?>" /></label>
		</p>

		<p>
			<label for="<?php echo esc_html( $this->get_field_id('username') ); ?>"><?php esc_html_e('Enter your twitter username:', "lacero" );?>
			<input class="widefat" id="<?php echo esc_html( $this->get_field_id('username') ); ?>" name="<?php echo esc_html( $this->get_field_name('username') ); ?>" type="text" value="<?php echo esc_attr($username); ?>" /></label>
		</p>

		<p>
			<label for="<?php echo esc_html( $this->get_field_id('count') ); ?>"><?php _e('How many entries do you want to show:', "lacero" );?>
				<select class="widefat" id="<?php echo esc_html( $this->get_field_id('count') ); ?>" name="<?php echo esc_html( $this->get_field_name('count') ); ?>">
					<?php
					for( $i = 1; $i <= 20; $i++ ):	
						$selected = ($count == $i ) ? "selected='selected'" : ""; ?>
						<option <?php echo($selected);?> value="<?php echo($i);?>"><?php echo($i);?></option>
						<?php
					endfor;
					?>
				</select>
			</label>
		</p>
		
		<p>
			<input type="checkbox" id="<?php echo esc_html( $this->get_field_id('exclude_replies') ); ?>" name="<?php echo esc_html( $this->get_field_name('exclude_replies') );?>" 
			<?php checked($exclude_replies); ?> /> <label for="<?php echo esc_html( $this->get_field_id('exclude_replies') ); ?>"><?php _e( 'Exclude @replies', "lacero" );?></label>
		</p>
		
		<p>
			<input type="checkbox"  id="<?php echo esc_html( $this->get_field_id('time') ); ?>" name="<?php echo esc_html( $this->get_field_name('time') );?>" 
			<?php checked($time); ?> /> <label for="<?php echo esc_html( $this->get_field_id('time') ); ?>"><?php _e( 'Show time of tweet', "lacero" );?></label>
		</p>

		<p>
			<input type="checkbox"  id="<?php echo esc_html( $this->get_field_id('time') ); ?>" name="<?php echo esc_html( $this->get_field_name('display_avatar') ); ?>" 
			<?php checked($display_avatar); ?> /> <label for="<?php echo esc_html( $this->get_field_id( 'display_avatar' ) ); ?>"><?php _e( 'Show user avatar', "lacero" );?></label>
		</p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {

		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['consumer_key'] = strip_tags($new_instance['consumer_key']);
		$instance['consumer_secret'] = strip_tags($new_instance['consumer_secret']);
		$instance['access_token'] = strip_tags($new_instance['access_token']);
		$instance['access_token_secret'] = strip_tags($new_instance['access_token_secret']);
		$instance['count'] = strip_tags($new_instance['count']);
		$instance['username'] = strip_tags($new_instance['username']);
		$instance['exclude_replies'] = empty($new_instance['exclude_replies']) ? 0 : 1;
		$instance['time'] = empty($new_instance['time']) ? 0 : 1;
		$instance['display_avatar'] = empty($new_instance['display_avatar']) ? 0 : 1;
		return $instance;
	}

	public function widget( $args, $instance ) {

		echo html_entity_decode( $args['before_widget'] );			

		$title = 			empty($instance['title']) ?	'' : strip_tags($instance['title']);
		$consumer_key = 			empty($instance['consumer_key']) ?	'' : strip_tags($instance['consumer_key']);
		$consumer_secret = 			empty($instance['consumer_secret']) ?	'' : strip_tags($instance['consumer_secret']);
		$access_token = 			empty($instance['access_token']) ?	'' : strip_tags($instance['access_token']);
		$access_token_secret = 			empty($instance['access_token_secret']) ?	'' : strip_tags($instance['access_token_secret']);
		$count = 			empty($instance['count']) ? '' : strip_tags($instance['count']);
		$username = 		empty($instance['username']) ? '' : strip_tags($instance['username']);
		$exclude_replies = 	empty($instance['exclude_replies']) ? false : true;
		$time = 			empty($instance['time']) ? false : true;
		$display_avatar = 	empty($instance['display_avatar']) ? false : true ;

		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );

		if ( $title ) {
			echo html_entity_decode( $args['before_title'] . $title . $args['after_title'] );
		}

		if( $username && $consumer_key && $consumer_secret && $access_token && $access_token_secret && $count ) { 

			$transName = 'list_tweets';
			$cacheTime = 10;
		
			require_once 'twitteroauth/twitteroauth.php';
			
			$twitterConnection = new TwitterOAuth($consumer_key, $consumer_secret, $access_token, $access_token_secret );
			$twitterData = $twitterConnection->get('statuses/user_timeline',array('screen_name' => $username, 'count' => $count,'exclude_replies' => $exclude_replies));
		
			if( $twitterConnection->http_code != 200 ) {
				 $twitterData = get_transient( $transName );
			 }
		 
			set_transient($transName, $twitterData, 60 * 10);
			$twitter = get_transient($transName);
			
			?>
			<ul class="tweets">
				<?php
				if( $twitter && is_array( $twitter ) ) {

					foreach( $twitter as $tweet ) {

						$latestTweet = $tweet->text;
						$latestTweet = preg_replace('/http:\/\/([a-z0-9_\.\-\+\&\!\#\~\/\,]+)/i', '<a href="http://$1" target="_blank">http://$1</a>', $latestTweet);
						$latestTweet = preg_replace('/@([a-z0-9_]+)/i', '<a href="http://twitter.com/$1" target="_blank">@$1</a>', $latestTweet);
						
						$twitterTime = strtotime($tweet->created_at);
						$twitterTime = !empty($tweet->utc_offset) ? $twitterTime+($tweet->utc_offset ) : $twitterTime;
						$timeAgo = date_i18n(  get_option('date_format'), $twitterTime ); 
						?>
						<li>
							<?php
							if( $display_avatar ) {
								?>
								<div class="col-md-12 col-sm-12 col-xs-12 no-padding">
									<div class="nopadding col-md-3 col-sm-4 col-xs-4 no-padding">
										<a href="http://twitter.com/<?php echo esc_attr( $username ); ?>"><img src="<?php echo esc_url( $tweet->user->profile_image_url ); ?>" alt="" /></a>
									</div>
									<div class="no-right-padding col-md-9 col-sm-8 col-xs-8">
										<p>
										<i class="fa fa-twitter"></i>
										<a href="http://twitter.com/<?php echo esc_attr( $username ); ?>" class="tweets-title"><?php echo esc_attr( '@'.$username ); ?></a>
										
											<?php
											echo html_entity_decode( $latestTweet );

											if( $time ) {
												?>
												<span><?php echo html_entity_decode( $timeAgo ); ?></span>
												<?php
											}
											?>
										</p>
									</div>
								</div>
								<?php
							}
							else {
								?>
								<div class="col-md-12 col-sm-12 col-xs-12 no-padding twitter-link ">
									<p>
									<i class="fa fa-twitter"></i>
									<a href="http://twitter.com/<?php echo esc_attr( $username ); ?>" class="tweets-title"><?php echo esc_attr( '@'.$username ); ?></a>
									
										<?php
										echo html_entity_decode( $latestTweet );

										if( $time ) {
											?>
											<span><?php echo html_entity_decode( $timeAgo ); ?></span>
											<?php
										}
										?>
									</p>
								</div>
								<?php
							}
							?>
						</li>
						<?php
					}
				}
				else {
					?>
					<li><?php esc_html_e( 'No public Tweets found', "lacero" ); ?></li>
					<?php
				}
				?>
			</ul>
			<?php
		}
		echo html_entity_decode( $args['after_widget'] );
	}
}