<?php

/**
 * Theme setup.
 *
 * Set up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support post thumbnails.
 *
 * @since Lacero 1.0
 */

if( !function_exists('lacero_widget_setup') ) :

	function lacero_widget_setup() {

		/* Script For Widget */
		add_image_size( 'lacero-82-82', 82, 82, true ); /* Recent Posts Widget */
		add_image_size( 'lacero-79-78', 79, 78, true ); /* Upcoming Events Widget */
	}
	add_action( 'after_setup_theme', 'lacero_widget_setup' );
endif;

/* Widget Register / UN-register */
function lacero_manage_widgets() {

	/* Recent Posts */
	require_once("recent_posts.php");
	register_widget( 'lacero_Widget_RecentPosts' );

	/* Widget Social */
	require_once("social_icons.php");
	register_widget( 'lacero_Widget_Social' );
	
	/* Twitter */
	require_once("twitter.php");
	register_widget( 'lacero_Widget_Recent_Tweets' );
	
	/* Flicker Upload */
	require_once("flicker_photos.php");
	register_widget( 'lacero_Widget_Flicker_Photos' );
	
	/*  About US */
	require_once("about_text.php");
	register_widget( 'lacero_Widget_About' );
	
	/*  Upoming Events */
	require_once("upcoming_events.php");
	register_widget( 'lacero_Widget_UpcomingEvents' );
	
}
add_action( 'widgets_init', 'lacero_manage_widgets' );