<?php
/**
 * Flickr Photos Widget class
 *
 * @since 1.0
 */
class lacero_Widget_Flicker_Photos extends WP_Widget {

	public function __construct() {
		$widget_ops = array('classname' => 'widget_flicker', 'description' => esc_html( 'A widget that show last flickr photo streams', "lacero" ) );
		parent::__construct( 'flicker_widget', esc_html( 'LACERO :: Flickr Widget' , "lacero" ), $widget_ops );
	}

	public function form( $instance ) {

		$instance = wp_parse_args( (array) $instance,
			array(
				'title' => '',
				'flickr_id' => '',
				'count' => '6',
				'show' => 'latest',
				'size' => 's',
			)
		);
		
		$title = empty( $instance['title'] ) ? 'Follow us on flickr' : strip_tags( $instance['title'] );
		$flickr_id = empty( $instance['flickr_id'] ) ? '' : strip_tags( $instance['flickr_id'] );
		$count = empty( $instance['count'] ) ? '' : strip_tags( $instance['count'] );
		$show = empty( $instance['show'] ) ? '' : strip_tags( $instance['show'] );
		$size = empty( $instance['size'] ) ? '' : strip_tags( $instance['size'] );
		?>
        
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title:','iamd_text_domain');?> 
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></label>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id('flickr_id'); ?>"><?php esc_html_e('Flickr ID:','iamd_text_domain');?>
			<input class="widefat" id="<?php echo $this->get_field_id('flickr_id'); ?>" name="<?php echo $this->get_field_name('flickr_id'); ?>" type="text" value="<?php echo esc_attr($flickr_id); ?>" /></label>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id('count'); ?>"><?php esc_html_e('How many entries do you want to show:','iamd_text_domain');?>
				<select class="widefat" id="<?php echo $this->get_field_id('count'); ?>" name="<?php echo $this->get_field_name('count'); ?>">
					<?php
					for($i = 1; $i <= 30; $i++):	
						$selected = ($count == $i ) ? "selected='selected'" : "";?>
						<option <?php echo($selected);?> value="<?php echo esc_attr($i);?>"><?php echo esc_attr($i);?></option>
						<?php
					endfor;
					?>
				</select>
			</label>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id('show');?>"><?php esc_html_e('What pictures to display','iamd_text_domain'); ?>
				<select class="widefat" id="<?php echo $this->get_field_id('show'); ?>" name="<?php echo $this->get_field_name('show'); ?>">
					<?php
					$a = array(
						"latest" => __( "Latest", "lacero" ),
						"random" => __( "Random", "lacero" )
					);
					
					foreach( $a as $key => $value ):
						$selected = ($show == $key ) ? "selected='selected'" : ""; 
						echo "<option value='$key' $selected> $value</option>";
					endforeach;
					?>	
				</select>
			</label>
		</p>
		<?php
	}

	public function update($new_instance, $old_instance) {

		$instance = $old_instance;

		$instance['title'] = strip_tags($new_instance['title']);
		$instance['count'] = strip_tags($new_instance['count']);
		$instance['flickr_id'] = strip_tags($new_instance['flickr_id']);
		$instance['show'] = strip_tags($new_instance['show']);
		$instance['target_link'] = strip_tags($new_instance['target_link']);

		return $instance;
	}

	public function widget($args, $instance) {
		
		echo html_entity_decode( $args['before_widget'] );

		$title =		empty($instance['title']) ?	'' : strip_tags($instance['title']);
		$flickr_id =	empty($instance['flickr_id']) ? '' : strip_tags($instance['flickr_id']);
		$count = 		empty($instance['count']) ? '' : strip_tags($instance['count']);
		$show = 		$instance['show'];
		$target_link = 		empty($instance['target_link']) ? '' : strip_tags($instance['target_link']);


		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		
		if ( $title ) {
			echo html_entity_decode( $args['before_title'] . $title . $args['after_title'] );
		}

		?>
		<div class="flickr_photos">
			<script type="text/javascript" src="http://www.flickr.com/badge_code_v2.gne?count=<?php echo esc_attr( $count ); ?>&amp;display=<?php echo esc_attr( $show ); ?>&amp;size=s&amp;layout=x&amp;source=user&amp;user=<?php echo esc_attr( $flickr_id ); ?>"></script>
		</div>
		<?php
		
		echo html_entity_decode( $args['after_widget'] );
	}
}