<?php
/**
 * Contact widget class LACERO
 *
 * @since 2.8.0
 */
class lacero_Widget_About extends WP_Widget {

	public function __construct() {

		$widget_ops = array( 'classname' => 'widget-about', 'description' => esc_html( "About Us", "lacero" ) );

		parent::__construct('widget_aboutus', esc_html('LACERO :: About Us', "lacero"), $widget_ops);

		$this->alt_option_name = 'widget_aboutus';
	}

	public function widget($args, $instance) {

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : esc_html( 'About Us', "lacero" );

		/** This filter is documented in wp-includes/default-widgets.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		$about_txt = ( ! empty( $instance['about_txt'] ) ) ? esc_attr( $instance['about_txt'] ) : "";

		$address = ( ! empty( $instance['address'] ) ) ? esc_attr( $instance['address'] ) : "";
		
		$contactone = ( ! empty( $instance['contactone'] ) ) ? esc_attr( $instance['contactone'] ) : "";
		
		$contacttwo = ( ! empty( $instance['contacttwo'] ) ) ? esc_attr( $instance['contactone'] ) : "";
		
		$contact_emailone = ( ! empty( $instance['contact_emailone'] ) ) ? esc_attr( $instance['contact_emailone'] ) : "";
		
		$contact_emailtwo = ( ! empty( $instance['contact_emailtwo'] ) ) ? esc_attr( $instance['contact_emailtwo'] ) : "";

		echo html_entity_decode( $args['before_widget'] );

		if ( $title ) {
			echo html_entity_decode( $args['before_title'] . $title . $args['after_title'] );
		}

		?>
		
		<div class="about-text">
			<span><?php echo esc_attr($about_txt); ?></span>
			<p><i class="fa fa-map-marker"></i> <?php echo esc_attr($address); ?></p>
			<p>
				<i class="fa fa-phone"></i> 
					<a class="text-phone" href="tel:<?php echo str_replace(' ', '', $contactone ); ?>"><?php echo esc_attr($contactone); ?></a>
					<a class="text-phone" href="tel:<?php echo str_replace(' ', '', $contacttwo ); ?>"><?php echo esc_attr($contacttwo); ?></a></p>
			<p>
				<i class="fa fa-envelope"></i>
				<a href="mailto:<?php echo esc_attr($contact_emailone); ?>"><?php echo esc_attr($contact_emailone); ?></a>
				<a href="mailto:<?php echo esc_attr($contact_emailtwo); ?>"><?php echo esc_attr($contact_emailtwo); ?></a>
			</p>
		</div>
		
		<?php
		echo html_entity_decode( $args['after_widget'] );
	}

	public function update( $new_instance, $old_instance ) {
		
		$instance = $old_instance;
		
		$instance['title'] = strip_tags( $new_instance['title'] );

		$instance['about_txt'] = strip_tags( $new_instance['about_txt'] );
		
		$instance['address'] = strip_tags( $new_instance['address'] );
		
		$instance['contactone'] = strip_tags( $new_instance['contactone'] );
		
		$instance['contacttwo'] = strip_tags( $new_instance['contacttwo'] );
		
		$instance['contact_emailone'] = strip_tags( $new_instance['contact_emailone'] );
		
		$instance['contact_emailtwo'] = strip_tags( $new_instance['contact_emailtwo'] );

		return $instance;
	}

	public function form( $instance ) {

		$title	=	isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : "";
		
		$about_txt	=	isset( $instance['about_txt'] ) ? esc_attr( $instance['about_txt'] ) : "";

		$address	=	isset( $instance['address'] ) ? esc_attr( $instance['address'] ) : "";
		
		$contactone	=	isset( $instance['contactone'] ) ? esc_attr( $instance['contactone'] ) : "";

		$contacttwo	=	isset( $instance['contacttwo'] ) ? esc_attr( $instance['contacttwo'] ) : "";
		
		$contact_emailone	=	isset( $instance['contact_emailone'] ) ? esc_attr( $instance['contact_emailone'] ) : "";
		
		$contact_emailtwo	=	isset( $instance['contact_emailtwo'] ) ? esc_attr( $instance['contact_emailtwo'] ) : "";
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', "lacero" ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'about_txt' ) ); ?>"><?php esc_html_e( 'About Text', "lacero" ); ?></label>
			<textarea class="widefat" id="<?php echo esc_attr( $this->get_field_id('about_txt') ); ?>" name="<?php echo esc_attr( $this->get_field_name('about_txt') ); ?>"><?php echo esc_attr( $about_txt ); ?></textarea>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'address' ) ); ?>"><?php esc_html_e( 'Address', "lacero" ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'address' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'address' ) ); ?>" type="text" value="<?php echo esc_attr( $address ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'contactone' ) ); ?>"><?php esc_html_e( 'Contact Number 1', "lacero" ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'contactone' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'contactone' ) ); ?>" type="text" value="<?php echo esc_attr( $contactone ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'contacttwo' ) ); ?>"><?php esc_html_e( 'Contact Number 2', "lacero" ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'contacttwo' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'contacttwo' ) ); ?>" type="text" value="<?php echo esc_attr( $contacttwo ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'contact_emailone' ) ); ?>"><?php esc_html_e( 'Contact Email 1', "lacero" ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'contact_emailone' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'contact_emailone' ) ); ?>" type="text" value="<?php echo esc_attr( $contact_emailone ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'contact_emailtwo' ) ); ?>"><?php esc_html_e( 'Contact Email 2', "lacero" ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'contact_emailtwo' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'contact_emailtwo' ) ); ?>" type="text" value="<?php echo esc_attr( $contact_emailtwo ); ?>" />
		</p>
		<?php
	}
}
?>