<?php
if ( ! function_exists( 'lacero_regform' ) ) :
	function lacero_regform() {
		echo do_shortcode( lacero_options("registrationform") );
	}
endif;

if ( ! function_exists( 'lacero_mcform' ) ) :
	function lacero_mcform() {
		echo do_shortcode( lacero_options("opt_mailchimp") );
	}
endif;

if ( ! function_exists( 'lacero_excerpt' ) ) :
	function lacero_excerpt( $limit ) {
		$excerpt = explode(' ', get_the_excerpt(), $limit);
		if ( count($excerpt) >= $limit ) :
		
			array_pop($excerpt);
			$excerpt = implode(" ",$excerpt).'...';
		
		else :
		
			$excerpt = implode(" ",$excerpt);
		
		endif; 

		$excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
		return $excerpt;
	}
endif;

if ( ! function_exists( 'lacero_length' ) ) :
	function lacero_length( $value, $limit ) {
		$excerpt = explode(' ', $value, $limit);
		if ( count($excerpt) >= $limit ) :
		
			array_pop($excerpt);
			$excerpt = implode(" ",$excerpt).'...';
		
		else :
		
			$excerpt = implode(" ",$excerpt);
		
		endif; 

		$excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
		return $excerpt;
	}
endif;

/* Check string for Null or Empty & Print It */
if ( ! function_exists( 'lacero_content' ) ) :

	function lacero_content( $before_val, $after_val, $val ) {

		if( $val != "" ) {
			return $before_val.$val.$after_val;
		}
		else {
			return "";
		}
	}
endif;

if( !function_exists('lacero_options') ) :

	function lacero_options( $option, $arr = null ) {

		global $lacero_option;

		if( $arr ) {

			if( isset( $lacero_option[$option][$arr] ) ) {
				return $lacero_option[$option][$arr];
			}
		}
		else {
			if( isset( $lacero_option[$option] ) ) {
				return $lacero_option[$option];
			}
		}
	}
endif;
?>