<?php
if ( ! function_exists('lacero_cpt_events') ) {

	// Register Custom Post Type
	function lacero_cpt_events() {

		$labels = array(
			'name'                  => _x( 'Events', 'Post Type General Name', "lacero" ),
			'singular_name'         => _x( 'Event', 'Post Type Singular Name', "lacero" ),
			'menu_name'             => __( 'Events', "lacero" ),
			'name_admin_bar'        => __( 'Event', "lacero" ),
			'archives'              => __( 'Item Archives', "lacero" ),
			'parent_item_colon'     => __( 'Parent Item:', "lacero" ),
			'all_items'             => __( 'All Items', "lacero" ),
			'add_new_item'          => __( 'Add New Item', "lacero" ),
			'add_new'               => __( 'Add New', "lacero" ),
			'new_item'              => __( 'New Item', "lacero" ),
			'edit_item'             => __( 'Edit Item', "lacero" ),
			'update_item'           => __( 'Update Item', "lacero" ),
			'view_item'             => __( 'View Item', "lacero" ),
			'search_items'          => __( 'Search Item', "lacero" ),
			'not_found'             => __( 'Not found', "lacero" ),
			'not_found_in_trash'    => __( 'Not found in Trash', "lacero" ),
			'featured_image'        => __( 'Featured Image', "lacero" ),
			'set_featured_image'    => __( 'Set featured image', "lacero" ),
			'remove_featured_image' => __( 'Remove featured image', "lacero" ),
			'use_featured_image'    => __( 'Use as featured image', "lacero" ),
			'insert_into_item'      => __( 'Insert into item', "lacero" ),
			'uploaded_to_this_item' => __( 'Uploaded to this item', "lacero" ),
			'items_list'            => __( 'Items list', "lacero" ),
			'items_list_navigation' => __( 'Items list navigation', "lacero" ),
			'filter_items_list'     => __( 'Filter items list', "lacero" ),
		);
	
		$rewrite = array(
			'slug'                  => 'event-item',
			'with_front'            => true,
			'pages'                 => true,
			'feeds'                 => true,
		);
	
		$args = array(
			'label'                 => __( 'Events', "lacero" ),
			'description'           => __( 'Events', "lacero" ),
			'labels'                => $labels,
			'supports'              => array( 'title', 'editor', 'thumbnail', ),
			'hierarchical'          => false,
			'public'                => true,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'rewrite'  => $rewrite,
			'menu_position' => 101,
			'menu_icon' => 'dashicons-clipboard',
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'can_export'            => true,
			'has_archive'           => 'events',
			'exclude_from_search'   => true,
			'publicly_queryable'    => true,
			'capability_type'       => 'page',
		);
	
		register_post_type( 'lacero_events', $args );
	}

	add_action( 'init', 'lacero_cpt_events', 0 );
}
?>